<?php
/**
 * Title: Footer
 * Slug: business-indexy/footer
 * Categories: business-indexy
 *
 * @link       https://fremontbusinessindex.com/
 * @since      1.0.0
 *
 * @package    business-indexy
 */

?>

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}},"backgroundColor":"accent-3","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-accent-3-background-color has-background" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)">

	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|60"}}}} -->
	<div class="wp-block-columns alignwide">

		<!-- wp:column {"width":"33.33%","className":"is-style-business-indexy-footer-one-logo"} -->
		<div class="wp-block-column is-style-business-indexy-footer-one-logo" style="flex-basis:33.33%">

			<?php if ( function_exists( 'the_custom_logo' ) && has_custom_logo() ) : ?>
			    <!-- wp:site-logo {"width":200,"shouldSyncIcon":true} /-->
			<?php else : ?>
				<!-- wp:site-title {"className":"is-style-business-indexy-header-one-title-dark"} /-->
			<?php endif; ?>

			<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"spacing":{"padding":{"top":"var:preset|spacing|10","bottom":"var:preset|spacing|10"}}},"textColor":"base-2"} -->
			<p class="has-base-2-color has-text-color has-link-color" style="padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10)">
			<?php esc_html_e( 'Turpis pharetra congue faucibus sagittis vestibulum habitasse volutpat.', 'business-indexy' ); ?></p>
			<!-- /wp:paragraph -->

			<!-- wp:social-links {"className":"is-style-logos-only is-style-business-indexy-footer-social"} -->
			<ul class="wp-block-social-links is-style-business-indexy-footer-social">

				<!-- wp:social-link {"url":"#","service":"facebook"} /-->
				<!-- wp:social-link {"url":"#","service":"x"} /-->
				<!-- wp:social-link {"url":"#","service":"instagram"} /-->
				<!-- wp:social-link {"url":"#","service":"linkedin"} /-->
				<!-- wp:social-link {"url":"#","service":"youtube"} /-->
			</ul>
			<!-- /wp:social-links -->

		</div>
		<!-- /wp:column -->

		<!-- wp:column {"width":"66.66%"} -->
		<div class="wp-block-column" style="flex-basis:66.66%">

			<!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|40"}}}} -->
			<div class="wp-block-columns">

				<!-- wp:column -->
				<div class="wp-block-column">

					<!-- wp:heading {"className":"is-style-business-indexy-footer-menu-heading"} -->
					<h2 class="wp-block-heading is-style-business-indexy-footer-menu-heading"><?php esc_html_e( 'Pages', 'business-indexy' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:list {"className":"is-style-business-indexy-footer-menu"} -->
					<ul class="wp-block-list is-style-business-indexy-footer-menu">

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Home', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'About Us', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Integrations', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Pricing', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Contact Us', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

					</ul>
					<!-- /wp:list -->

				</div>
				<!-- /wp:column -->

				<!-- wp:column -->
				<div class="wp-block-column">

					<!-- wp:heading {"className":"is-style-business-indexy-footer-menu-heading"} -->
					<h2 class="wp-block-heading is-style-business-indexy-footer-menu-heading"><?php esc_html_e( 'Company', 'business-indexy' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:list {"className":"is-style-business-indexy-footer-menu"} -->
					<ul class="wp-block-list is-style-business-indexy-footer-menu">

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Home', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'About Us', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Integrations', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Pricing', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Contact Us', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

					</ul>
					<!-- /wp:list -->

				</div>
				<!-- /wp:column -->

				<!-- wp:column -->
				<div class="wp-block-column">

					<!-- wp:heading {"className":"is-style-business-indexy-footer-menu-heading"} -->
					<h2 class="wp-block-heading is-style-business-indexy-footer-menu-heading"><?php esc_html_e( 'Information', 'business-indexy' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:list {"className":"is-style-business-indexy-footer-menu"} -->
					<ul class="wp-block-list is-style-business-indexy-footer-menu">

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Home', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'About Us', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Integrations', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Pricing', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

						<!-- wp:list-item {"className":"is-style-business-indexy-footer-menu-item"} -->
						<li class="is-style-business-indexy-footer-menu-item">
							<a href="" data-type="link" data-id=""><?php esc_html_e( 'Contact Us', 'business-indexy' ); ?></a>
						</li>
						<!-- /wp:list-item -->

					</ul>
					<!-- /wp:list -->

				</div>
				<!-- /wp:column -->

			</div>
			<!-- /wp:columns -->

		</div>
		<!-- /wp:column -->

	</div>
	<!-- /wp:columns -->

</div>
<!-- /wp:group -->

<!-- wp:group {"className":"is-style-business-indexy-y10a4","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-business-indexy-y10a4">
    
    <!-- wp:paragraph {"className":"is-style-business-indexy-b2center-small has-base-color has-text-color has-link-color","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base"} -->
    <p class="is-style-business-indexy-b2center-small has-base-color has-text-color has-link-color">
        <?php printf( '%1$s <a href="%2$s">%3$s</a>', esc_html__( 'Designed by', 'business-indexy' ), esc_url( 'https://fremontbusinessindex.com/' ), esc_html__( 'Fremont Business Index', 'business-indexy' ) ); ?>
	</p>
    <!-- /wp:paragraph -->

</div>
<!-- /wp:group -->
