<?php
/**
 * Title: About One
 * Slug: business-indexy/about-one
 * Categories: business-indexy
 *
 * @link       https://fremontbusinessindex.com/
 * @since      1.0.0
 *
 * @package    business-indexy
 */

?>

<!-- wp:group {"className":"is-style-business-indexy-y60","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-business-indexy-y60">
    
    <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|50"}}}} -->
    <div class="wp-block-columns alignwide">
        
        <!-- wp:column -->
        <div class="wp-block-column">
            
            <!-- wp:image {"id":1845,"sizeSlug":"full","linkDestination":"none"} -->
            <figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_theme_file_uri( 'assets/images/800-900-grey.webp' ) ); ?>" alt="" class="wp-image-1845"/></figure>
            <!-- /wp:image -->
            
        </div>
        <!-- /wp:column -->

        <!-- wp:column -->
        <div class="wp-block-column">
            
            <!-- wp:heading {"level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent"}}}},"textColor":"accent"} -->
            <h4 class="wp-block-heading has-accent-color has-text-color has-link-color"><?php esc_html_e( 'About Us', 'business-indexy' ); ?></h4>
            <!-- /wp:heading -->

            <!-- wp:heading {"className":"is-style-business-indexy-t10","fontSize":"xx-large"} -->
            <h2 class="wp-block-heading is-style-business-indexy-t10 has-xx-large-font-size"><?php esc_html_e( 'Process Oriented Business Solutions', 'business-indexy' ); ?></h2>
            <!-- /wp:heading -->

            <!-- wp:paragraph -->
            <p><?php esc_html_e( 'We help businesses identify growth opportunities and create actionable strategies to achieve long-term success. Our consulting team works closely with you to streamline operations, reduce costs, and improve overall efficiency.', 'business-indexy' ); ?></p>
            <!-- /wp:paragraph -->

            <!-- wp:list {"className":"is-style-business-indexy-about"} -->
            <ul class="wp-block-list is-style-business-indexy-about">
                
                <!-- wp:list-item {"className":"is-style-business-indexy-about-item"} -->
                <li class="is-style-business-indexy-about-item"><?php esc_html_e( 'Data-driven insights', 'business-indexy' ); ?></li>
                <!-- /wp:list-item -->

                <!-- wp:list-item {"className":"is-style-business-indexy-about-item"} -->
                <li class="is-style-business-indexy-about-item"><?php esc_html_e( 'Strategy to execution', 'business-indexy' ); ?></li>
                <!-- /wp:list-item -->

                <!-- wp:list-item {"className":"is-style-business-indexy-about-item"} -->
                <li class="is-style-business-indexy-about-item"><?php esc_html_e( 'optimize performance', 'business-indexy' ); ?></li>
                <!-- /wp:list-item -->

                <!-- wp:list-item {"className":"is-style-business-indexy-about-item"} -->
                <li class="is-style-business-indexy-about-item"><?php esc_html_e( 'Proven frameworks', 'business-indexy' ); ?></li>
                <!-- /wp:list-item -->

                <!-- wp:list-item {"className":"is-style-business-indexy-about-item"} -->
                <li class="is-style-business-indexy-about-item"><?php esc_html_e( 'Improve overall efficiency', 'business-indexy' ); ?></li>
                <!-- /wp:list-item -->

                <!-- wp:list-item {"className":"is-style-business-indexy-about-item"} -->
                <li class="is-style-business-indexy-about-item"><?php esc_html_e( 'Hands-on approach', 'business-indexy' ); ?></li>
                <!-- /wp:list-item -->

            </ul>
            <!-- /wp:list -->   

            <!-- wp:buttons -->
            <div class="wp-block-buttons">
                <!-- wp:button {"className":"is-style-business-indexy-rounded-b2"} -->
                <div class="wp-block-button is-style-business-indexy-rounded-b2">
                    
                        <a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Read More', 'business-indexy' ); ?></a>
                
                </div>
                <!-- /wp:button -->
                
            </div>
            <!-- /wp:buttons -->
            
        </div>
        <!-- /wp:column -->
        
    </div>
    <!-- /wp:columns -->
    
</div>
<!-- /wp:group -->