<?php
/**
 * Functions.
 *
 * @link       https://fremontbusinessindex.com/
 * @since      1.0.0
 *
 * @package    business-indexy
 */

/**
 * Enqueue Assets.
 *
 * @since    1.0.0
 */
function business_blitz_enqueue_assets() {

	$business_blitz_variables             = array();
	$business_blitz_variables['assetDir'] = esc_url( get_stylesheet_directory_uri() ) . '/assets/';

	wp_register_script( 'business-indexy-theme', esc_url( get_stylesheet_directory_uri() ) . '/assets/js/script.js', array( 'jquery' ), '1.0.0', true );
	wp_localize_script( 'business-indexy-theme', 'businessBlitzVariables', $business_blitz_variables );
	wp_enqueue_script( 'business-indexy-theme' );

}
add_action( 'wp_enqueue_scripts', 'business_blitz_enqueue_assets' );
add_action( 'enqueue_block_editor_assets', 'business_blitz_enqueue_assets' );

/**
 * Set the default image if none exists.
 *
 * @param string $html              The post thumbnail HTML.
 * @param int    $post_id           The post ID.
 * @param int    $post_thumbnail_id The post thumbnail ID.
 * @return html
 */
function business_blitz_fallback_post_thumbnail_html( $html, $post_id, $post_thumbnail_id ) {

	if ( empty( $html ) ) {
		$html = '<img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/default-600-400-2.webp" width="400" height="200" loading="lazy" alt="' . get_the_title( $post_id ) . '" />';
	}

	return $html;

}
add_filter( 'post_thumbnail_html', 'business_blitz_fallback_post_thumbnail_html', 5, 3 );

/**
 * Set the default image if none exists.
 */
function business_blitz_pattern_categories() {
	register_block_pattern_category(
		'business-indexy',
		array( 'label' => __( 'Business Indexy', 'business-indexy' ) )
	);

}

add_action( 'init', 'business_blitz_pattern_categories' );

/**
 * Register block styles.
 *
 * @since    1.0.0
 */
function business_blitz_register_block_styles() {

	foreach ( glob( __DIR__ . '/inc/block-styles/*.php' ) as $file ) {
		include_once $file;
	}
}
add_action( 'init', 'business_blitz_register_block_styles' );

require_once get_template_directory() . '/inc/tgmpa/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'business_blitz_register_required_plugins' );

/**
 * Register required plugins using TGMPA.
 *
 * @since 1.0.0
 */
function business_blitz_register_required_plugins() {

	$plugins = array(
		array(
			'name'     => esc_html__( 'Buzzolt Reviews & Testimonials', 'business-indexy' ),
			'slug'     => 'buzzolt-reviews-testimonials',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Zypento Mailchimp Integration', 'business-indexy' ),
			'slug'     => 'zypento-mailchimp',
			'required' => false,
		),
	);

	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id'           => 'business-indexy',    // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );

}


