<?php
/**
* Loads all the components related to customizer 
*
* @since Business Gravity 1.0.0
*/
require get_parent_theme_file_path( '/modules/customizer/framework/customizer.php' );
require get_parent_theme_file_path( '/modules/customizer/panels/panels.php' );
require get_parent_theme_file_path( '/modules/customizer/sections/sections.php' );

require get_parent_theme_file_path( '/modules/customizer/settings/general.php' );
require get_parent_theme_file_path( '/modules/customizer/settings/frontpage.php' );
require get_parent_theme_file_path( '/modules/customizer/defaults/defaults.php' );


function business_gravity_modify_default_settings( $wp_customize ){

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
	$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
	$wp_customize->get_control( 'background_color' )->label = esc_html__( 'Background', 'business-gravity' );
}
add_action( 'business_gravity_customize_register', 'business_gravity_modify_default_settings' );

function business_gravity_default_styles(){
	
	$site_title_color         = business_gravity_get_option( 'site_title_color' );
	$site_tagline_color       = business_gravity_get_option( 'site_tagline_color' );
	$primary_color            = business_gravity_get_option( 'site_primary_color' );
	$hover_color              = business_gravity_get_option( 'site_hover_color' );
	$slider_control           = business_gravity_get_option( 'slider_control' );
	$highlight_section_title  = business_gravity_get_option( 'highlight_section_title' );
	$callback_bg              = business_gravity_get_callback_banner_url();
	$footer_callback_bg       = business_gravity_get_footer_callback_banner_url();
	
	?>
	<style type="text/css">
		.offcanvas-menu-open .kt-offcanvas-overlay {
		    position: fixed;
		    width: 100%;
		    height: 100%;
		    background: rgba(0, 0, 0, 0.7);
		    opacity: 1;
		    z-index: 99991;
		    top: 0px;
		}
		.kt-offcanvas-overlay {
		    width: 0;
		    height: 0;
		    opacity: 0;
		    transition: opacity 0.5s;
		}
		.masonry-grid.wrap-post-list {
			width: 100% !important;
		}

		<?php if( business_gravity_get_option( 'disable_header_button' ) ):?>
			header:not(.site-header-two) #header-bottom-right-outer .callback-button {
				display: none;
			}
		<?php endif; ?>

		<?php if( $header_two ): ?>
			.top-header {
				display: none !important;
			}
		<?php endif; ?>

		<?php if( !$slider_control ): ?>
			.block-slider .controls, .block-slider .owl-pager {
				opacity: 0;
			}
		<?php endif; ?>
		.block-callback {
		   background-image: url(<?php echo esc_url( $callback_bg ); ?> );
		}
		.block-footer-callback {
		   background-image: url(<?php echo esc_url( $footer_callback_bg ); ?> );
		}

		/*======================================*/
		/* Site title */
		/*======================================*/
		.site-header .site-branding .site-title,
		.site-header .site-branding .site-title a,
		.wrap-fixed-header .site-branding .site-title a {
			color: <?php echo esc_attr( $site_title_color ); ?>;
		}

		/*======================================*/
		/* Tagline title */
		/*======================================*/
		.site-header:not(.site-header-four) .site-branding .site-description {
			color: <?php echo esc_attr( $site_tagline_color ); ?>;
		}

		/*======================================*/
		/* Primary color */
		/*======================================*/

		/*======================================*/
		/* Background Primary color */
		/*======================================*/

		::-webkit-selection {
		  background-color: <?php echo esc_attr( $primary_color ); ?>
		}

		::-moz-selection {
		  background-color: <?php echo esc_attr( $primary_color ); ?>
		}

		::-ms-selection {
		  background-color: <?php echo esc_attr( $primary_color ); ?>
		}

		::-o-selection {
		  background-color: <?php echo esc_attr( $primary_color ); ?>
		}

		::selection {
		  background-color: <?php echo esc_attr( $primary_color ); ?>
		}
		table thead tr, .wrap-detail-page form input[type=submit], .wrap-detail-page .wpcf7 input[type=submit], .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit], input[type=button], input[type=reset], input[type=submit], .default-button, .button-primary, .button-primary:hover, .button-primary:focus, .button-primary:active, .section-title:before, .page-numbers.current, .page-numbers:hover.current, .page-numbers:focus.current, .page-numbers:active.current, .widget.widget_mc4wp_form_widget input[type=submit], .woocommerce ul.products li.product .onsale, .woocommerce ul.products li.product .button, .woocommerce ul.products li.product a.added_to_cart, body.single article.hentry .post-text .page-links > .page-number, .page article.hentry .post-text .page-links > .page-number, #blog-post article.hentry .post-text .page-links > .page-number, .search article.hentry .post-text .page-links > .page-number, .archive article.hentry .post-text .page-links > .page-number, .tag article.hentry .post-text .page-links > .page-number, .category article.hentry .post-text .page-links > .page-number, article.hentry #ak-blog-post .post-text .page-links > .page-number, article.hentry.sticky .post-thumb:before, article.hentry.sticky .post-format-outer > span a, body.single .post-footer span.cat-links:before, .comments-area .comment-list .reply a, .comments-area .comment-respond .comment-form .submit, .searchform .search-button, .widget.widget_calendar tbody a, .top-header-right .search-icon button, .top-header-right .cart-icon a .count, .header-bottom-right .header-search-wrap .search-icon, .block-portfolio.block-grid .gallery-content .post-content-inner .icon-area, .meta .meta-date a, .contact-form-section input[type=submit], .kt-contact-form-area .form-group input.form-control[type=submit], .block-footer-callback .mc4wp-form input[type=submit]{
			background-color: <?php echo esc_attr( $primary_color ); ?>
		}

		/*======================================*/
		/* Primary border color */
		/*======================================*/
		.wrap-detail-page .wpcf7 input[type=submit], .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit], .button-primary, .page-numbers.current, .page-numbers:hover.current, .page-numbers:focus.current, .page-numbers:active.current, .woocommerce ul.products li.product .button, .woocommerce ul.products li.product a.added_to_cart, body.single article.hentry .post-text .page-links > .page-number, .page article.hentry .post-text .page-links > .page-number, #blog-post article.hentry .post-text .page-links > .page-number, .search article.hentry .post-text .page-links > .page-number, .archive article.hentry .post-text .page-links > .page-number, .tag article.hentry .post-text .page-links > .page-number, .category article.hentry .post-text .page-links > .page-number, article.hentry #ak-blog-post .post-text .page-links > .page-number, .comments-area .comment-respond .comment-form .submit, .homepage-layout-three .site-header.site-header-two .main-header .top-header .top-header-right .callback-button a, body.fixed-nav-active .main-navigation .nav > ul > li.current-menu-item, .main-navigation ul ul, .contact-form-section input[type=submit], .kt-contact-form-area .form-group input.form-control[type=submit], .main-navigation ul li.current-menu-item > a, .main-navigation ul li.current-menu-parent > a {
			border-color: <?php echo esc_attr( $primary_color ); ?>
		}

		/*======================================*/
		/* Primary text color */
		/*======================================*/
		.woocommerce ul.products li.product .price .amount, .woocommerce ul.products li.product .price ins .amount, .widget.widget_calendar tfoot a, .widget.widget_rss li a, .header-bottom-right .callback-button a:hover span, .header-bottom-right .callback-button a:focus span, .header-bottom-right .callback-button a:active span, .site-header.site-header-two .header-contact .list span[class*=kfi], .homepage-layout-three .site-header.site-header-two .main-header .top-header .top-header-right .callback-button a, .offcanvas-navigation li.current_page_item > a, .offcanvas-navigation li.current-menu-item > a, .offcanvas-navigation li.current_page_ancestor > a, .offcanvas-navigation li.current-menu-ancestor > a, .icon-block-outer .icon-outer span, .main-navigation ul li.current-menu-item > a, .main-navigation ul li.current-menu-parent > a {
		  color: <?php echo esc_attr( $primary_color ); ?>
		}

		/*======================================*/
		/* Hover color */
		/*======================================*/

		/*======================================*/
		/* Background Hover color */
		/*======================================*/
		.wrap-detail-page form input[type=submit]:hover, .wrap-detail-page form input[type=submit]:focus, .wrap-detail-page form input[type=submit]:active, .wrap-detail-page .wpcf7-form input.wpcf7-form-control[type=submit]:hover, .wrap-detail-page .wpcf7-form input.wpcf7-form-control[type=submit]:focus, .wrap-detail-page .wpcf7-form input.wpcf7-form-control[type=submit]:active, .wrap-detail-page .wpcf7 input[type=submit]:hover, .wrap-detail-page .wpcf7 input[type=submit]:active, .wrap-detail-page .wpcf7 input[type=submit]:focus, .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit]:hover, .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit]:focus, .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit]:active, .comments-area .comment-list .reply a:hover, .button-outline:hover, .button-light:hover, .button-primary:hover, .default-button:hover, .button:hover, input[type=button]:hover, input[type=reset]:hover, input[type=submit]:hover, .comments-area .comment-list .reply a:focus, .button-outline:focus, .button-light:focus, .button-primary:focus, .default-button:focus, .button:focus, input[type=button]:focus, input[type=reset]:focus, input[type=submit]:focus, .comments-area .comment-list .reply a:active, .button-outline:active, .button-light:active, .button-primary:active, .default-button:active, .button:active, input[type=button]:active, input[type=reset]:active, input[type=submit]:active, .button-light:hover, .button-light:focus, .button-light:active, .page-numbers:hover, .page-numbers:focus, .page-numbers:active, .infinite-scroll #infinite-handle span:hover, .infinite-scroll #infinite-handle span:focus, .infinite-scroll #infinite-handle span:active, .widget.widget_mc4wp_form_widget input[type=submit]:hover, .widget.widget_mc4wp_form_widget input[type=submit]:focus, .widget.widget_mc4wp_form_widget input[type=submit]:active, .woocommerce ul.products li.product .onsale:hover, .woocommerce ul.products li.product .onsale:focus, .woocommerce ul.products li.product .onsale:active, .woocommerce ul.products li.product .button:hover, .woocommerce ul.products li.product .button:active, .woocommerce ul.products li.product a.added_to_cart:hover, .woocommerce ul.products li.product a.added_to_cart:focus, .woocommerce ul.products li.product a.added_to_cart:active, body.single article.hentry .post-text .page-links .page-number:hover, body.single article.hentry .post-text .page-links .page-number:focus, body.single article.hentry .post-text .page-links .page-number:active, .page article.hentry .post-text .page-links .page-number:hover, .page article.hentry .post-text .page-links .page-number:focus, .page article.hentry .post-text .page-links .page-number:active, #blog-post article.hentry .post-text .page-links .page-number:hover, #blog-post article.hentry .post-text .page-links .page-number:focus, #blog-post article.hentry .post-text .page-links .page-number:active, .search article.hentry .post-text .page-links .page-number:hover, .search article.hentry .post-text .page-links .page-number:focus, .search article.hentry .post-text .page-links .page-number:active, .archive article.hentry .post-text .page-links .page-number:hover, .archive article.hentry .post-text .page-links .page-number:focus, .archive article.hentry .post-text .page-links .page-number:active, .tag article.hentry .post-text .page-links .page-number:hover, .tag article.hentry .post-text .page-links .page-number:focus, .tag article.hentry .post-text .page-links .page-number:active, .category article.hentry .post-text .page-links .page-number:hover, .category article.hentry .post-text .page-links .page-number:focus, .category article.hentry .post-text .page-links .page-number:active, article.hentry #ak-blog-post .post-text .page-links .page-number:hover, article.hentry #ak-blog-post .post-text .page-links .page-number:focus, article.hentry #ak-blog-post .post-text .page-links .page-number:active, body.single article.hentry .post-text .page-links > .page-number:hover, body.single article.hentry .post-text .page-links > .page-number:focus, body.single article.hentry .post-text .page-links > .page-number:active, .page article.hentry .post-text .page-links > .page-number:hover, .page article.hentry .post-text .page-links > .page-number:focus, .page article.hentry .post-text .page-links > .page-number:active, #blog-post article.hentry .post-text .page-links > .page-number:hover, #blog-post article.hentry .post-text .page-links > .page-number:focus, #blog-post article.hentry .post-text .page-links > .page-number:active, .search article.hentry .post-text .page-links > .page-number:hover, .search article.hentry .post-text .page-links > .page-number:focus, .search article.hentry .post-text .page-links > .page-number:active, .archive article.hentry .post-text .page-links > .page-number:hover, .archive article.hentry .post-text .page-links > .page-number:focus, .archive article.hentry .post-text .page-links > .page-number:active, .tag article.hentry .post-text .page-links > .page-number:hover, .tag article.hentry .post-text .page-links > .page-number:focus, .tag article.hentry .post-text .page-links > .page-number:active, .category article.hentry .post-text .page-links > .page-number:hover, .category article.hentry .post-text .page-links > .page-number:focus, .category article.hentry .post-text .page-links > .page-number:active, article.hentry #ak-blog-post .post-text .page-links > .page-number:hover, article.hentry #ak-blog-post .post-text .page-links > .page-number:focus, article.hentry #ak-blog-post .post-text .page-links > .page-number:active, body.single .post-footer span.cat-links a:hover, body.single .post-footer span.cat-links a:focus, body.single .post-footer span.cat-links a:active, .comments-area .comment-respond .comment-form .submit:hover, .comments-area .comment-respond .comment-form .submit:focus, .comments-area .comment-respond .comment-form .submit:active, .searchform .search-button:hover, .searchform .search-button:focus, .searchform .search-button:active, article.post-content .post-title .cat:hover:after, article.post-content .post-title .cat:focus:after, article.post-content .post-title .cat:active:after, #go-top:hover span, #go-top:focus span, #go-top:active span, .widget.widget_calendar tbody a:hover, .widget.widget_calendar tbody a:focus, .widget.widget_calendar tbody a:active, .widget.widget_tag_cloud .tagcloud a:hover, .widget.widget_tag_cloud .tagcloud a:focus, .widget.widget_tag_cloud .tagcloud a:active, .top-header-right .search-icon button:hover, .top-header-right .search-icon button:focus, .top-header-right .search-icon button:active, .top-header-right .cart-icon a:hover span.count, .top-header-right .cart-icon a:focus span.count, .top-header-right .cart-icon a:active span.count, .header-bottom-right .callback-button a:hover, .header-bottom-right .callback-button a:focus, .header-bottom-right .callback-button a:active, .header-bottom-right .header-search-wrap .search-icon:hover, .header-bottom-right .header-search-wrap .search-icon:focus, .header-bottom-right .header-search-wrap .search-icon:active, .homepage-layout-three .site-header.site-header-two .main-header .top-header .top-header-right .callback-button a:hover, .block-slider .controls .owl-prev:hover:before, .block-slider .controls .owl-prev:focus:before, .block-slider .controls .owl-prev:active:before, .block-slider .controls .owl-next:hover:before, .block-slider .controls .owl-next:focus:before, .block-slider .controls .owl-next:active:before, .block-slider #kt-slide-pager .owl-dot span:hover, .block-slider #kt-slide-pager .owl-dot span:focus, .block-slider #kt-slide-pager .owl-dot span:active, .block-slider #kt-slide-pager .owl-dot.active span:hover, .block-slider #kt-slide-pager .owl-dot.active span:focus, .block-slider #kt-slide-pager .owl-dot.active span:active, .block-top-footer .widget .search-button:hover, .block-top-footer .widget .search-button:focus, .block-top-footer .widget .search-button:active, .block-portfolio.block-grid .gallery-content .post-content-inner .icon-area:hover, .block-highlight #kt-slide-pager .owl-dot span:hover, .block-highlight #kt-slide-pager .owl-dot span:focus, .block-highlight #kt-slide-pager .owl-dot span:active, .block-highlight #kt-slide-pager .owl-dot.active span:hover, .block-highlight #kt-slide-pager .owl-dot.active span:focus, .block-highlight #kt-slide-pager .owl-dot.active span:active, .meta .meta-date a:hover, .meta .meta-date a:focus, .meta .meta-date a:active, .kt-contact-form-area .form-group input.form-control[type=submit]:hover, .kt-contact-form-area .form-group input.form-control[type=submit]:focus, .kt-contact-form-area .form-group input.form-control[type=submit]:active, .block-footer-callback .mc4wp-form input[type=submit]:hover, .block-footer-callback .mc4wp-form input[type=submit]:focus, .block-footer-callback .mc4wp-form input[type=submit]:active {
				background-color: <?php echo esc_attr( $hover_color ); ?>
		    }

		    /*======================================*/
			/* Border Hover color */
			/*======================================*/
			.wrap-detail-page form input[type=submit]:hover, .wrap-detail-page form input[type=submit]:focus, .wrap-detail-page form input[type=submit]:active, .wrap-detail-page .wpcf7-form input.wpcf7-form-control[type=submit]:hover, .wrap-detail-page .wpcf7-form input.wpcf7-form-control[type=submit]:focus, .wrap-detail-page .wpcf7-form input.wpcf7-form-control[type=submit]:active, .wrap-detail-page .wpcf7 input[type=submit]:hover, .wrap-detail-page .wpcf7 input[type=submit]:active, .wrap-detail-page .wpcf7 input[type=submit]:focus, .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit]:hover, .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit]:focus, .wrap-detail-page .kt-contact-form-area .form-group input.form-control[type=submit]:active, .button-light:hover, .button-light:focus, .button-light:active, .button-outline:hover, .button-outline:focus, .button-outline:active, .page-numbers:hover, .page-numbers:focus, .page-numbers:active, .widget .bbp-login-links a:hover, .widget .bbp-login-links a:focus, .widget .bbp-login-links a:active, .widget.widget_mc4wp_form_widget input[type=submit]:hover, .widget.widget_mc4wp_form_widget input[type=submit]:focus, .widget.widget_mc4wp_form_widget input[type=submit]:active, .woocommerce ul.products li.product .button:hover, .woocommerce ul.products li.product .button:active, .woocommerce ul.products li.product a.added_to_cart:hover, .woocommerce ul.products li.product a.added_to_cart:focus, .woocommerce ul.products li.product a.added_to_cart:active, body.single article.hentry .post-text .page-links .page-number:hover, body.single article.hentry .post-text .page-links .page-number:focus, body.single article.hentry .post-text .page-links .page-number:active, .page article.hentry .post-text .page-links .page-number:hover, .page article.hentry .post-text .page-links .page-number:focus, .page article.hentry .post-text .page-links .page-number:active, #blog-post article.hentry .post-text .page-links .page-number:hover, #blog-post article.hentry .post-text .page-links .page-number:focus, #blog-post article.hentry .post-text .page-links .page-number:active, .search article.hentry .post-text .page-links .page-number:hover, .search article.hentry .post-text .page-links .page-number:focus, .search article.hentry .post-text .page-links .page-number:active, .archive article.hentry .post-text .page-links .page-number:hover, .archive article.hentry .post-text .page-links .page-number:focus, .archive article.hentry .post-text .page-links .page-number:active, .tag article.hentry .post-text .page-links .page-number:hover, .tag article.hentry .post-text .page-links .page-number:focus, .tag article.hentry .post-text .page-links .page-number:active, .category article.hentry .post-text .page-links .page-number:hover, .category article.hentry .post-text .page-links .page-number:focus, .category article.hentry .post-text .page-links .page-number:active, article.hentry #ak-blog-post .post-text .page-links .page-number:hover, article.hentry #ak-blog-post .post-text .page-links .page-number:focus, article.hentry #ak-blog-post .post-text .page-links .page-number:active, body.single article.hentry .post-text .page-links > .page-number:hover, body.single article.hentry .post-text .page-links > .page-number:focus, body.single article.hentry .post-text .page-links > .page-number:active, .page article.hentry .post-text .page-links > .page-number:hover, .page article.hentry .post-text .page-links > .page-number:focus, .page article.hentry .post-text .page-links > .page-number:active, #blog-post article.hentry .post-text .page-links > .page-number:hover, #blog-post article.hentry .post-text .page-links > .page-number:focus, #blog-post article.hentry .post-text .page-links > .page-number:active, .search article.hentry .post-text .page-links > .page-number:hover, .search article.hentry .post-text .page-links > .page-number:focus, .search article.hentry .post-text .page-links > .page-number:active, .archive article.hentry .post-text .page-links > .page-number:hover, .archive article.hentry .post-text .page-links > .page-number:focus, .archive article.hentry .post-text .page-links > .page-number:active, .tag article.hentry .post-text .page-links > .page-number:hover, .tag article.hentry .post-text .page-links > .page-number:focus, .tag article.hentry .post-text .page-links > .page-number:active, .category article.hentry .post-text .page-links > .page-number:hover, .category article.hentry .post-text .page-links > .page-number:focus, .category article.hentry .post-text .page-links > .page-number:active, article.hentry #ak-blog-post .post-text .page-links > .page-number:hover, article.hentry #ak-blog-post .post-text .page-links > .page-number:focus, article.hentry #ak-blog-post .post-text .page-links > .page-number:active, body.single .post-footer span.cat-links a:hover, body.single .post-footer span.cat-links a:focus, body.single .post-footer span.cat-links a:active, .comments-area .comment-respond .comment-form .submit:hover, .comments-area .comment-respond .comment-form .submit:focus, .comments-area .comment-respond .comment-form .submit:active, #go-top:hover span, #go-top:focus span, #go-top:active span, .widget.widget_tag_cloud .tagcloud a:hover, .widget.widget_tag_cloud .tagcloud a:focus, .widget.widget_tag_cloud .tagcloud a:active, .top-header-right .socialgroup a:hover, .top-header-right .socialgroup a:focus, .top-header-right .socialgroup a:active, .homepage-layout-three .site-header.site-header-two .main-header .top-header .top-header-right .callback-button a:hover, body.fixed-nav-active .main-navigation .nav > ul > li:hover, .block-slider .home-slider .post-title .button-outline:hover, .block-slider .home-slider .post-title .button-outline:focus, .block-slider .home-slider .post-title .button-outline:active, .block-slider .home-slider .content .button-outline:hover, .block-slider .home-slider .content .button-outline:focus, .block-slider .home-slider .content .button-outline:active, .block-slider .home-slider .button-container .button-outline:hover, .block-slider .home-slider .button-container .button-outline:focus, .block-slider .home-slider .button-container .button-outline:active, .block-slider #kt-slide-pager .owl-dot span:hover, .block-slider #kt-slide-pager .owl-dot span:focus, .block-slider #kt-slide-pager .owl-dot span:active, .main-navigation ul > li > a:hover, .main-navigation ul > li > a:focus, .main-navigation ul > li > a:active, .main-navigation ul > li:hover > a, .main-navigation ul > li:focus > a, .main-navigation ul > li:active > a, .main-navigation ul > li.focus > a, .footer-social .socialgroup ul li a:hover, .footer-social .socialgroup ul li a:focus, .footer-social .socialgroup ul li a:active, .block-highlight .controls .owl-prev:hover:before, .block-highlight .controls .owl-prev:focus:before, .block-highlight .controls .owl-prev:active:before, .block-highlight .controls .owl-next:hover:before, .block-highlight .controls .owl-next:focus:before, .block-highlight .controls .owl-next:active:before, .block-highlight #kt-slide-pager .owl-dot span:hover, .block-highlight #kt-slide-pager .owl-dot span:focus, .block-highlight #kt-slide-pager .owl-dot span:active, .kt-contact-form-area .form-group input.form-control[type=submit]:hover, .kt-contact-form-area .form-group input.form-control[type=submit]:focus, .kt-contact-form-area .form-group input.form-control[type=submit]:active, .block-footer-callback .mc4wp-form input[type=submit]:hover, .block-footer-callback .mc4wp-form input[type=submit]:focus, .block-footer-callback .mc4wp-form input[type=submit]:active, .site-header-four .main-navigation > ul > li > a:hover, .site-header-four .main-navigation > ul > li > a:focus, .site-header-four .main-navigation > ul > li > a:active, .site-header-four .main-navigation ul li.current-menu-item > a:hover, .site-header-four .main-navigation ul li.current-menu-item > a:focus, .site-header-four .main-navigation ul li.current-menu-item > a:active, .site-header-four .main-navigation ul li.current-menu-parent > a:hover, .site-header-four .main-navigation ul li.current-menu-parent > a:focus, .site-header-four .main-navigation ul li.current-menu-parent > a:active, .button-primary:hover, .button-primary:focus, .button-primary:active {
					border-color: <?php echo esc_attr( $hover_color ); ?>
				}

				/*======================================*/
				/* Hover color */
				/*======================================*/
				a:hover, a:focus, a:active, .wrap-detail-page .kt-contact-form-area .form-group .cleaner:hover, .wrap-detail-page .kt-contact-form-area .form-group .cleaner:active, .wrap-detail-page .kt-contact-form-area .form-group .cleaner:focus, .wrap-detail-page .kt-contact-form-area .form-group .cleaner:hover span, .wrap-detail-page .kt-contact-form-area .form-group .cleaner:active span, .wrap-detail-page .kt-contact-form-area .form-group .cleaner:focus span, a.button-text:hover, a.button-text:focus, a.button-text:active, .button-text:hover, .button-text:focus, .button-text:active, a.button-text:hover:after, a.button-text:focus:after, a.button-text:active:after, .button-text:hover:after, .button-text:focus:after, .button-text:active:after, h1 a:hover, h1 a:focus, h1 a:active, h2 a:hover, body.woocommerce.single-product .product_title a:hover, h2 a:focus, body.woocommerce.single-product .product_title a:focus, h2 a:active, body.woocommerce.single-product .product_title a:active, h3 a:hover, h3 a:focus, h3 a:active, h4 a:hover, h4 a:focus, h4 a:active, h5 a:hover, h5 a:focus, h5 a:active, h6 a:hover, h6 a:focus, h6 a:active, body.bbpress article.hentry .post-text a:hover, body.bbpress article.hentry .post-text a:focus, body.bbpress article.hentry .post-text a:active, .woocommerce ul.products li.product h2:hover, body.woocommerce.single-product ul.products li.product .product_title:hover, .woocommerce ul.products li.product h2:focus, body.woocommerce.single-product ul.products li.product .product_title:focus, .woocommerce ul.products li.product h2:active, body.woocommerce.single-product ul.products li.product .product_title:active, .woocommerce ul.products li.product .woocommerce-loop-product__title:hover, .woocommerce ul.products li.product .woocommerce-loop-product__title:focus, .woocommerce ul.products li.product .woocommerce-loop-product__title:active, .woocommerce ul.products li.product .price del .amount:hover, .woocommerce ul.products li.product .price ins .amount:hover, .woocommerce ul.products li.product .price del .amount:focus, .woocommerce ul.products li.product .price ins .amount:focus, .woocommerce ul.products li.product .price del .amount:active, .woocommerce ul.products li.product .price ins .amount:active, body.single article.hentry .post-text a:not(.wp-block-button__link):hover, body.single article.hentry .post-text a:not(.wp-block-button__link):focus, body.single article.hentry .post-text a:not(.wp-block-button__link):active, .page article.hentry .post-text a:not(.wp-block-button__link):hover, .page article.hentry .post-text a:not(.wp-block-button__link):focus, .page article.hentry .post-text a:not(.wp-block-button__link):active, #blog-post article.hentry .post-text a:not(.wp-block-button__link):hover, #blog-post article.hentry .post-text a:not(.wp-block-button__link):focus, #blog-post article.hentry .post-text a:not(.wp-block-button__link):active, .search article.hentry .post-text a:not(.wp-block-button__link):hover, .search article.hentry .post-text a:not(.wp-block-button__link):focus, .search article.hentry .post-text a:not(.wp-block-button__link):active, .archive article.hentry .post-text a:not(.wp-block-button__link):hover, .archive article.hentry .post-text a:not(.wp-block-button__link):focus, .archive article.hentry .post-text a:not(.wp-block-button__link):active, .tag article.hentry .post-text a:not(.wp-block-button__link):hover, .tag article.hentry .post-text a:not(.wp-block-button__link):focus, .tag article.hentry .post-text a:not(.wp-block-button__link):active, .category article.hentry .post-text a:not(.wp-block-button__link):hover, .category article.hentry .post-text a:not(.wp-block-button__link):focus, .category article.hentry .post-text a:not(.wp-block-button__link):active, article.hentry #ak-blog-post .post-text a:not(.wp-block-button__link):hover, article.hentry #ak-blog-post .post-text a:not(.wp-block-button__link):focus, article.hentry #ak-blog-post .post-text a:not(.wp-block-button__link):active, body.single article.hentry .post-text a:not(.wp-block-button__link).button-text:hover, body.single article.hentry .post-text a:not(.wp-block-button__link).button-text:focus, body.single article.hentry .post-text a:not(.wp-block-button__link).button-text:active, .page article.hentry .post-text a:not(.wp-block-button__link).button-text:hover, .page article.hentry .post-text a:not(.wp-block-button__link).button-text:focus, .page article.hentry .post-text a:not(.wp-block-button__link).button-text:active, #blog-post article.hentry .post-text a:not(.wp-block-button__link).button-text:hover, #blog-post article.hentry .post-text a:not(.wp-block-button__link).button-text:focus, #blog-post article.hentry .post-text a:not(.wp-block-button__link).button-text:active, .search article.hentry .post-text a:not(.wp-block-button__link).button-text:hover, .search article.hentry .post-text a:not(.wp-block-button__link).button-text:focus, .search article.hentry .post-text a:not(.wp-block-button__link).button-text:active, .archive article.hentry .post-text a:not(.wp-block-button__link).button-text:hover, .archive article.hentry .post-text a:not(.wp-block-button__link).button-text:focus, .archive article.hentry .post-text a:not(.wp-block-button__link).button-text:active, .tag article.hentry .post-text a:not(.wp-block-button__link).button-text:hover, .tag article.hentry .post-text a:not(.wp-block-button__link).button-text:focus, .tag article.hentry .post-text a:not(.wp-block-button__link).button-text:active, .category article.hentry .post-text a:not(.wp-block-button__link).button-text:hover, .category article.hentry .post-text a:not(.wp-block-button__link).button-text:focus, .category article.hentry .post-text a:not(.wp-block-button__link).button-text:active, article.hentry #ak-blog-post .post-text a:not(.wp-block-button__link).button-text:hover, article.hentry #ak-blog-post .post-text a:not(.wp-block-button__link).button-text:focus, article.hentry #ak-blog-post .post-text a:not(.wp-block-button__link).button-text:active, .post-footer a:hover, .post-footer a:focus, .post-footer a:active, .post-footer a:hover span, .post-footer a:focus span, .post-footer a:active span, .cat-links > a:hover:before, .cat-links > a:focus:before, .cat-links > a:active:before, .tag-links > a:hover:before, .tag-links > a:focus:before, .tag-links > a:active:before, .comment-link > a:hover:before, .comment-link > a:focus:before, .comment-link > a:active:before, .posted-on > a:hover:before, .posted-on > a:focus:before, .posted-on > a:active:before, body.logged-in article.hentry .edit-link .post-edit-link:hover, body.logged-in article.hentry .edit-link .post-edit-link:focus, body.logged-in article.hentry .edit-link .post-edit-link:active, body.logged-in article.hentry .edit-link .comment-edit-link:hover, body.logged-in article.hentry .edit-link .comment-edit-link:focus, body.logged-in article.hentry .edit-link .comment-edit-link:active, .nav-links .nav-previous a:hover, .nav-links .nav-previous a:focus, .nav-links .nav-previous a:active, .nav-links .nav-next a:hover, .nav-links .nav-next a:focus, .nav-links .nav-next a:active, .nav-previous:hover:before, .nav-previous:focus:before, .nav-previous:active:before, .nav-next:hover:before, .nav-next:focus:before, .nav-next:active:before, .comments-area .comment-list .comment-metadata a:hover, .comments-area .comment-list .comment-metadata a:focus, .comments-area .comment-list .comment-metadata a:active, .comments-area .comment-respond .logged-in-as a:hover, .comments-area .comment-respond .logged-in-as a:focus, .comments-area .comment-respond .logged-in-as a:active, .related-post .related-post-list h3 a:hover, .related-post .related-post-list h3 a:focus, .related-post .related-post-list h3 a:active, .breadcrumb-wrap .breadcrumbs .trail-items a:hover, .breadcrumb-wrap .breadcrumbs .trail-items a:focus, .breadcrumb-wrap .breadcrumbs .trail-items a:active, .post-content-overlay article.post-content .post-title h2 a:hover, .post-content-overlay article.post-content .post-title body.woocommerce.single-product .product_title a:hover, body.woocommerce.single-product .post-content-overlay article.post-content .post-title .product_title a:hover, .post-content-overlay article.post-content .post-title h2 a:focus, .post-content-overlay article.post-content .post-title body.woocommerce.single-product .product_title a:focus, body.woocommerce.single-product .post-content-overlay article.post-content .post-title .product_title a:focus, .post-content-overlay article.post-content .post-title h2 a:active, .post-content-overlay article.post-content .post-title body.woocommerce.single-product .product_title a:active, body.woocommerce.single-product .post-content-overlay article.post-content .post-title .product_title a:active, .post-content-overlay article.post-content .post-title .cat a:hover, .post-content-overlay article.post-content .post-title .cat a:focus, .post-content-overlay article.post-content .post-title .cat a:active, .post-content-overlay article.post-content .post-footer a:hover, .post-content-overlay article.post-content .post-footer a:focus, .post-content-overlay article.post-content .post-footer a:active, .post-content-overlay article.post-content .post-footer .divider:hover, .post-content-overlay article.post-content .post-footer .divider:focus, .post-content-overlay article.post-content .post-footer .divider:active, .widget li:hover > a, .widget li:focus > a, .widget li:active > a, .widget.widget_calendar tfoot a:hover, .widget.widget_calendar tfoot a:focus, .widget.widget_calendar tfoot a:active, .widget.widget_rss li a:hover, .widget.widget_rss li a:focus, .widget.widget_rss li a:active, .widget.widget_rss .widget-title .rsswidget:hover, .widget.widget_rss .widget-title .rsswidget:focus, .widget.widget_rss .widget-title .rsswidget:active, widget.widget_text .textwidget a:hover, .widget.widget_text .textwidget a:focus, .widget.widget_text .textwidget a:active, .top-header .top-header-left .list a:hover, .top-header .top-header-left .list a:focus, .top-header .top-header-left .list a:active, .top-header-right .socialgroup a:hover, .top-header-right .socialgroup a:focus, .top-header-right .socialgroup a:active, .top-header-right .cart-icon a:hover, .top-header-right .cart-icon a:focus, .top-header-right .cart-icon a:active, .site-header .site-branding .site-title a:hover, .site-header .site-branding .site-title a:focus, .site-header .site-branding .site-title a:active, .site-header.site-header-two .header-contact .list a:hover, .site-header.site-header-two .header-contact .list a:focus, .site-header.site-header-two .header-contact .list a:active, .site-header.site-header-two .header-bottom-right div .cart-icon a:hover span, .site-header.site-header-two .header-bottom-right div .cart-icon a:focus span, .site-header.site-header-two .header-bottom-right div .cart-icon a:active span, .site-header-four.site-header .site-branding .site-title a:hover, .site-header-four.site-header .site-branding .site-title a:focus, .site-header-four.site-header .site-branding .site-title a:active, .block-slider .slide-item .button-container .post-footer-detail > a:hover, .block-slider .slide-item .button-container .post-footer-detail > a:focus, .block-slider .slide-item .button-container .post-footer-detail > a:active, .main-navigation ul > li > a:hover, .main-navigation ul > li > a:focus, .main-navigation ul > li > a:active, .main-navigation ul > li:hover > a, .main-navigation ul > li:focus > a, .main-navigation ul > li:active > a, .main-navigation ul > li.focus > a, .main-navigation ul ul li a:hover, .main-navigation ul ul li a:focus, .main-navigation ul ul li a:active, #offcanvas-menu .header-contact .top-header-left .list a:hover, #offcanvas-menu .top-header-right .socialgroup a:hover, .offcanvas-navigation a:hover, .offcanvas-navigation a:focus, .offcanvas-navigation a:active, .footer-social .socialgroup ul li a:hover, .footer-social .socialgroup ul li a:focus, .footer-social .socialgroup ul li a:active, .site-info a:hover, .site-info a:focus, .site-info a:active, .footer-menu ul li a:hover, .footer-menu ul li a:focus, .footer-menu ul li a:active, .block-top-footer .widget ul li a:hover, .block-top-footer .widget ul li a:focus, .block-top-footer .widget ul li a:active, .block-top-footer .widget ol li a:hover, .block-top-footer .widget ol li a:focus, .block-top-footer .widget ol li a:active, .block-top-footer .widget .textwidget a:hover, .block-top-footer .widget .textwidget a:focus, .block-top-footer .widget .textwidget a:active, .block-top-footer .widget.widget_rss li a:hover, .block-top-footer .widget.widget_rss li a:focus, .block-top-footer .widget.widget_rss li a:active, .block-top-footer .widget .rsswidget:hover, .block-top-footer .widget .rsswidget:focus, .block-top-footer .widget .rsswidget:active, .block-top-footer .widget .sb-right-thumb-widget .widget-content .post-footer span a:hover, .block-top-footer .widget .sb-right-thumb-widget .widget-content .post-footer span a:focus, .block-top-footer .widget .sb-right-thumb-widget .widget-content .post-footer span a:active, .block-top-footer .widget .sb-right-thumb-widget .widget-content a:hover, .block-top-footer .widget .sb-right-thumb-widget .widget-content a:focus, .block-top-footer .widget .sb-right-thumb-widget .widget-content a:active, .block-portfolio.block-grid .gallery-content .post-content-inner .post-title h3:hover, .block-testimonial .kt-pager a:hover, .block-testimonial .kt-pager a:focus, .block-testimonial .kt-pager a:active, .block-highlight .slide-item .button-container .post-footer-detail > a:hover, .block-highlight .slide-item .button-container .post-footer-detail > a:focus, .block-highlight .slide-item .button-container .post-footer-detail > a:active, .post-content .post-inner .author-name a:hover, .post-content .post-inner .author-name a:focus, .post-content .post-inner .author-name a:active, .post-content .post-inner .comment-link a:hover, .post-content .post-inner .comment-link a:focus, .post-content .post-inner .comment-link a:active, .post-content .post-inner .comment-link a:hover:before, .post-content .post-inner .comment-link a:focus:before, .post-content .post-inner .comment-link a:active:before, .cat a:hover, .cat a:focus, .cat a:active, .author-name a:hover, .author-name a:focus, .author-name a:active, .comment-link a:hover, .comment-link a:focus, .comment-link a:active, .kt-contact-form-area .form-group .cleaner:hover, .kt-contact-form-area .form-group .cleaner:active, .kt-contact-form-area .form-group .cleaner:focus, .kt-contact-form-area .form-group .cleaner:hover span, .kt-contact-form-area .form-group .cleaner:active span, .kt-contact-form-area .form-group .cleaner:focus span, .site-header-four .main-navigation > ul > li > a:hover, .site-header-four .main-navigation > ul > li > a:focus, .site-header-four .main-navigation > ul > li > a:active, .site-header-four .main-navigation ul li.current-menu-item > a:hover, .site-header-four .main-navigation ul li.current-menu-item > a:focus, .site-header-four .main-navigation ul li.current-menu-item > a:active, .site-header-four .main-navigation ul li.current-menu-parent > a:hover, .site-header-four .main-navigation ul li.current-menu-parent > a:focus, .site-header-four .main-navigation ul li.current-menu-parent > a:active, body.fixed-nav-active .wrap-fixed-header .site-branding .site-title a:hover, body.fixed-nav-active .wrap-fixed-header .site-branding .site-title a:active, body.fixed-nav-active .wrap-fixed-header .site-branding .site-title a:focus, {
						color: <?php echo esc_attr( $hover_color ); ?>
				}

	</style>
	<?php
}
add_action( 'wp_head', 'business_gravity_default_styles' );

/**
* Load customizer preview js file
*/
function business_gravity_customize_preview_js() {
	wp_enqueue_script( 'business-gravity-customize-preview', get_theme_file_uri( '/assets/js/customizer/customize-preview.js' ), array( 'jquery', 'customize-preview'), '1.0', true );
}
add_action( 'customize_preview_init', 'business_gravity_customize_preview_js' );