<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Business_Center
 * @since Business Center 1.0.0
 */

if ( ! function_exists( 'business_center_add_testimonial_section' ) ) :
  /**
   * Add testimonial section
   *
   *@since Business Center 1.0.0
   */
  function business_center_add_testimonial_section() {
    // Check if testimonial is enabled
    $enable_testimonial = apply_filters( 'business_center_section_status', true, 'enable_testimonial' );

    if ( true !== $enable_testimonial ) {
      return false;
    }

    // Get testimonial section details
    $section_details = array();

    $section_details = apply_filters( 'business_center_filter_testimonial_section_details', $section_details );

    if ( empty( $section_details ) ) {
      return;
    }

    // Render testimonial section now.
    business_center_render_testimonial_section( $section_details );
  }
endif;
add_action( 'business_center_core_modules', 'business_center_add_testimonial_section', 30 );


if ( ! function_exists( 'business_center_get_testimonial_section_details' ) ) :
  /**
   * Testimonial section details.
   *
   * @since Business Center 1.0.0
   * @param array $input Testimonial section details.
   */
  function business_center_get_testimonial_section_details( $input ) {
    $options = business_center_get_theme_options();

    // Testimonial type
    $testimonial_content_type  = $options['testimonial_content_type'];

    $content = array();
    switch ( $testimonial_content_type ) {
        case 'category':
          $cat_id = array();
          if ( !empty( $options['testimonial_category'] ) ) {
              $cat_id = $options['testimonial_category'];
          }

          // Bail if no valid pages are selected.
          if ( empty( $cat_id ) ) {
              return $input;
          }else{
              $cat_id =  (array)$cat_id;
          }
          $args = array(
              'no_found_rows'  => true,
              'category__in'   => $cat_id,
              'post_type'      => 'post',
              'posts_per_page' => 4,
              'orderby'        => 'ASC',
          );
        break;

        default:
        break;
    }

    if ( 'demo' != $testimonial_content_type && 'custom' != $testimonial_content_type ) {
      // Fetch posts.
      $posts = get_posts( $args );

      if ( ! empty( $posts ) ) {

          $i = 1;
          foreach ( $posts as $key => $post ) {
            $post_id = $post->ID;

            $content[ $i ]['title']       = get_the_title( $post_id );
            $content[ $i ]['content']   = business_center_trim_content( 20, $post );

            $content[ $i ]['link']      = get_permalink( $post_id );
            $content[ $i ]['name_company']     = get_the_title( $post_id );
            if ( has_post_thumbnail( $post_id ) ) {
                $featured_img = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ) );
                $img_array = $featured_img[0];
            } else {
                $img_array =  '';
            }

            if ( isset( $img_array ) ) {
              $content[$i]['img_array'][0] = $img_array;
            }

            $i++;
          }
      }
    }

    if ( ! empty( $content ) ) {
      $input = $content;
    }
    return $input;
  }
endif;
// Testimonial section content details.
add_filter( 'business_center_filter_testimonial_section_details', 'business_center_get_testimonial_section_details' );


if ( ! function_exists( 'business_center_render_testimonial_section' ) ) :
  /**
   * Start testimonial section
   *
   * @return string Testimonial content
   * @since Business Center 1.0.0
   *
   */
   function business_center_render_testimonial_section( $content_details = array() ) {
        $options = business_center_get_theme_options();

        if ( empty( $content_details ) ) {
          return;
        }
        ?>
        <section id="client-testimonial-slider" class="page-section">
          <div class="container">
            <header class="entry-header">
              <div class="separate"></div>
              <h2 class="entry-title category-title"><?php echo esc_html( $options['testimonial_title'] );?></h2>
            </header><!-- .entry-header -->

            <div class="entry-content regular" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "speed": 800, "dots": true, "arrows":false, "autoplay": true, "fade": false, "centerMode": true, "focusOnSelect": true }'>
              <?php foreach ( $content_details as $content ) { ?>
                <div class="slider-item">
                <?php
                $link = ( ! empty( $content['link'] ) ) ? $content['link'] : '#';
                $name_company = ( ! empty( $content['name_company'] ) ) ? $content['name_company'] : '';
                ?>
                  <a href="<?php echo esc_url( $link );?>">
                    <img src="<?php echo esc_url( $content['img_array'][0] );?>" alt="<?php echo esc_attr( $name_company );?>">
                  </a>
                  <?php if ( ! empty( $name_company ) ) { ?>
                    <a class="client-name" href="<?php echo esc_url( $content['link'] );?>"><?php echo esc_html( $name_company );?></a>
                  <?php }
                  if ( ! empty( $content['content'] ) ) { ?>
                    <blockquote><?php echo esc_html( $content['content'] ); ?></blockquote>
                  <?php } ?>
                </div><!-- .slider-item -->
              <?php } ?>

            </div><!-- .entry-content -->
          </div><!-- .container -->
        </section><!-- #testimonal-->
<?php
    }
endif;