<?php 
/**
 * Service section
 *
 * This is the template for the content of service section
 *
 * @package Business_Center
 * @since Business Center 1.0.0
 */

if ( ! function_exists( 'business_center_add_service_section' ) ) :
  /**
   * Add service section
   *
   *@since Business Center 1.0.0
   */
  function business_center_add_service_section() {
    // Check if service is enabled
    $enable_service = apply_filters( 'business_center_section_status', true, 'enable_service' );

    if ( true !== $enable_service ) {
      return false;
    }

    // Get service section details
    $section_details = array();

    $section_details = apply_filters( 'business_center_filter_service_section_details', $section_details );

    if ( empty( $section_details ) ) {
      return;
    }

    // Render service section now.
    business_center_render_service_section( $section_details );
  }
endif;
add_action( 'business_center_core_modules', 'business_center_add_service_section', 30 );


if ( ! function_exists( 'business_center_get_service_section_details' ) ) :
  /**
   * Service section details.
   *
   * @since Business Center 1.0.0
   * @param array $input Service section details.
   */
  function business_center_get_service_section_details( $input ) {
    $options = business_center_get_theme_options();

    // Service type
    $service_content_type  = $options['service_content_type'];

    $content = array();
    switch ( $service_content_type ) {

        case 'category':
          $cat_id = array();
          if ( !empty( $options['service_category'] ) ) {
              $cat_id = $options['service_category'];
          }

          // Bail if no valid pages are selected.
          if ( empty( $cat_id ) ) {
              return $input;
          }else{
              $cat_id =  (array)$cat_id;
          }
          $args = array(
              'no_found_rows'  => true,
              'category__in'   => $cat_id,
              'post_type'      => 'post',
              'posts_per_page' => 3,
              'orderby'        => 'ASC',
          );
        break;

        default:
        break;
    }

    // Fetch posts.
    $posts = get_posts( $args );

    if ( ! empty( $posts ) ) {

        $i = 1;
        foreach ( $posts as $key => $post ) {
          $post_id = $post->ID;

          $content[ $i ]['title']       = get_the_title( $post_id );
          $content[ $i ]['sub_title']   = business_center_trim_content( 20, $post );
          $content[ $i ]['url']         = get_the_permalink( $post_id );
          if ( isset( $options['custom_service_icon_'.$i] ) ) {
              $content[ $i ]['icon']      = $options['custom_service_icon_'.$i];
          }
          $i++;
        }
    }

  if ( ! empty( $content ) ) {
    $input = $content;
  }
  return $input;
  }
endif;
// Service section content details.
add_filter( 'business_center_filter_service_section_details', 'business_center_get_service_section_details' );


if ( ! function_exists( 'business_center_render_service_section' ) ) :
  /**
   * Start service section
   *
   * @return string Service content
   * @since Business Center 1.0.0
   *
   */
   function business_center_render_service_section( $content_details = array() ) {
        $options = business_center_get_theme_options();

        if ( empty( $content_details ) ) {
          return;
        } 
        ?>
        <section id="services" class="page-section bg-white">
          <div class="container">
            <header class="entry-header">
              <div class="separate"></div>
              <h2 class="entry-title"><?php echo esc_html( $options['service_title'] ); ?></h2>  
            </header><!-- .entry-header -->

            <div class="entry-content three-columns">
              <div class="row">
              <?php foreach ( $content_details as $content ) { 
                ?>
                <div class="column-wrapper">
                    <div class="title">
                      <!-- <span>01</span> -->
                      <?php if ( ! empty( $content['icon'] ) ) { ?>
                        <span><i class="fa <?php echo esc_attr( $content['icon'] );?>"></i></span>
                      <?php } ?>
                      <?php if ( ! empty( $content['title'] ) ) { ?>
                        <a href="<?php echo esc_url( $content['url'] ); ?>"><h3><?php echo esc_html( $content['title'] ); ?></h3></a> 
                      <?php } ?>
                      <?php if ( ! empty( $content['sub_title'] ) ) { ?>
                        <p><?php echo esc_html( $content['sub_title'] ); ?></p>
                      <?php } ?>
                    </div><!-- .title -->
                </div><!-- .column-wrapper -->
              <?php  }  ?>
              </div><!-- .row -->
            </div><!-- .entry-content -->
            </div><!-- .container -->
        </section><!-- #services -->
<?php 
    }
endif;