<?php
/**
 * Testimonial options
 *
 * @package Theme Palace
 * @subpackage Business_Center
 * @since Business Center 1.0.0
 */


// Add testimonial section
$wp_customize->add_section( 'business_center_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial Options','business-center' ),
	'description'       => esc_html__( 'Testimonial options.', 'business-center' ),
	'panel'             => 'business_center_sections_panel',
) );

/**
 * Testimonial Options
 */
// Enable testimonial.
$wp_customize->add_setting( 'business_center_theme_options[enable_testimonial]', array(
	'default'           => $options['enable_testimonial'],
	'sanitize_callback' => 'business_center_sanitize_checkbox',
) );

$wp_customize->add_control( 'business_center_theme_options[enable_testimonial]', array(
	'label'             => esc_html__( 'Enable Testimonial Section?', 'business-center' ),
	'section'           => 'business_center_testimonial_section',
	'type'				=> 'checkbox'
) );

// Testimonial title.
$wp_customize->add_setting( 'business_center_theme_options[testimonial_title]', array(
	'default'           => $options['testimonial_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'business_center_theme_options[testimonial_title]', array(
	'active_callback'	=> 'business_center_is_testimonial_enable',
	'label'             => esc_html__( 'Title:', 'business-center' ),
	'section'           => 'business_center_testimonial_section',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_center_theme_options[testimonial_title]', array(
		'selector'            => '#client-testimonial-slider .entry-header .entry-title',
		'render_callback'     => 'business_center_partial_testimonial_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

/**
 * Testimonial content type options.
 */
$wp_customize->add_setting( 'business_center_theme_options[testimonial_content_type]', array(
	'default'           => $options['testimonial_content_type'],
	'sanitize_callback' => 'business_center_sanitize_select',
) );

$wp_customize->add_control( 'business_center_theme_options[testimonial_content_type]', array(
	'active_callback'	=> 'business_center_is_testimonial_enable',
	'label'             => esc_html__( 'Content Type', 'business-center' ),
	'section'           => 'business_center_testimonial_section',
	'choices'			=> business_center_testimonial_content_type_options(),
	'type'				=> 'select'
) );

/**
 * Category Content Type Options
 */
// Catgegory Options
$wp_customize->add_setting( 'business_center_theme_options[testimonial_category]', array(
	'sanitize_callback' => 'business_center_sanitize_tax_checkbox'
) );

$wp_customize->add_control( new Business_Center_Customize_Control_Checkbox_Multiple( $wp_customize, 'business_center_theme_options[testimonial_category]', array(
	'active_callback' => 'business_center_is_testimonial_enable',
	'label'           => esc_html__( 'Select Category', 'business-center' ),
	'description'     => esc_html__( 'Latest 4 posts from selected categories will be shown.', 'business-center' ),
	'section'         => 'business_center_testimonial_section',
	'type'            => 'checkbox-multiple',
	'taxonomy'		  => 'category',
) ) );
