<?php
/**
 * Service options
 *
 * @package Theme Palace
 * @subpackage Business_Center
 * @since Business Center 1.0.0
 */


// Add service section
$wp_customize->add_section( 'business_center_service_section', array(
	'title'             => esc_html__( 'Service Options','business-center' ),
	'description'       => esc_html__( 'Service options.', 'business-center' ),
	'panel'             => 'business_center_sections_panel',
) );


/**
 * Service Options
 */
// Enable service.
$wp_customize->add_setting( 'business_center_theme_options[enable_service]', array(
	'default'           => $options['enable_service'],
	'sanitize_callback' => 'business_center_sanitize_checkbox',
) );

$wp_customize->add_control( 'business_center_theme_options[enable_service]', array(
	'label'             => esc_html__( 'Enable Service Section?', 'business-center' ),
	'section'           => 'business_center_service_section',
	'type'				=> 'checkbox'
) );

/**
 * Service Options
 */
// Service title.
$wp_customize->add_setting( 'business_center_theme_options[service_title]', array(
	'default'           => $options['service_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'business_center_theme_options[service_title]', array(
	'active_callback'	=> 'business_center_is_service_enable',
	'label'             => esc_html__( 'Title:', 'business-center' ),
	'section'           => 'business_center_service_section',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_center_theme_options[service_title]', array(
		'selector'            => '#services .entry-header .entry-title',
		'render_callback'     => 'business_center_partial_service_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

/**
 * Service content type options.
 */
$wp_customize->add_setting( 'business_center_theme_options[service_content_type]', array(
	'default'           => $options['service_content_type'],
	'sanitize_callback' => 'business_center_sanitize_select',
) );

$wp_customize->add_control( 'business_center_theme_options[service_content_type]', array(
	'active_callback'	=> 'business_center_is_service_enable',
	'label'             => esc_html__( 'Content Type', 'business-center' ),
	'section'           => 'business_center_service_section',
	'choices'			=> business_center_service_content_type_options(),
	'type'				=> 'select'
) );

for ( $i=1; $i <= 3; $i++ ) { 
	
	// Service icon Options
	$wp_customize->add_setting( 'business_center_theme_options[custom_service_icon_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_center_theme_options[custom_service_icon_'.$i.']', array(
		'active_callback' => 'business_center_is_service_enable',
		'label'           => esc_html__( 'Service Icon ', 'business-center' ) . $i,
		'section'         => 'business_center_service_section',
		'type'            => 'text',
		'input_attrs'	  => array( 'placeholder' => esc_attr__( 'fa-archive', 'business-center' ) )
	) );

}

/**
 * Category Content Type Options
 */
// Catgegory Options
$wp_customize->add_setting( 'business_center_theme_options[service_category]', array(
	'sanitize_callback' => 'business_center_sanitize_tax_checkbox'
) );

$wp_customize->add_control( new Business_Center_Customize_Control_Checkbox_Multiple( $wp_customize, 'business_center_theme_options[service_category]', array(
	'active_callback' => 'business_center_is_service_enable',
	'label'           => esc_html__( 'Select Category', 'business-center' ),
	'description'     => esc_html__( 'Latest 3 posts from selected categories will be shown.', 'business-center' ),
	'section'         => 'business_center_service_section',
	'type'            => 'checkbox-multiple',
	'taxonomy'		  => 'category',
) ) );