<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'business-assistant' ); ?></a>

<?php if(get_theme_mod('business_assistant_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'business_assistant_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'business-assistant' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'business_assistant_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>

<header id="site-navigationn">
	<div class="header-center-box wow fadeInDown">
		<div class="container">
			<div class="row m-0">
				<div class="col-lg-3 col-md-12 col-sm-12 align-self-center">
					<div class="logo text-lg-start text-center">
			    		<div class="logo-image">
			    			<?php the_custom_logo(); ?>
				    	</div>
				    	<div class="logo-content">
					    	<?php
					    		if ( get_theme_mod('business_assistant_display_header_title', true) == true ) :
						      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
						      			echo esc_html(get_bloginfo('name'));
						      		echo '</a>';
						      	endif;

						      	if ( get_theme_mod('business_assistant_display_header_text', false) == true ) :
					      			echo '<span>'. esc_html(get_bloginfo('description')) . '</span>';
					      		endif;
				    		?>
						</div>
					</div>
				</div>
				<div class="col-lg-8 col-md-12 col-sm-12 align-self-center top-area">
					<div class="row top-header">
						<div class="col-lg-4 col-md-4 col-sm-4 align-self-center">
							<?php if ( get_theme_mod('business_assistant_header_phone_number') ) : ?>
	                        	<p class="mb-0"><i class="fas fa-phone me-2"></i><?php echo esc_html( get_theme_mod('business_assistant_header_phone_number' ) ); ?></p>
		                    <?php endif; ?>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-4 align-self-center">
							<?php if ( get_theme_mod('business_assistant_header_email_address') ) : ?>
	                        	<p class="mb-0"><i class="fas fa-envelope me-2"></i><?php echo esc_html( get_theme_mod('business_assistant_header_email_address' ) ); ?></p>
		                    <?php endif; ?>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-4 align-self-center">
							<?php if ( get_theme_mod('business_assistant_header_address_location') ) : ?>
	                        	<p class="mb-0"><i class="fas fa-map-marker-alt me-2"></i><?php echo esc_html( get_theme_mod('business_assistant_header_address_location' ) ); ?></p>
		                    <?php endif; ?>
						</div>
					</div>
					<div class="row header-area">
						<div class="col-lg-8 col-md-2 col-sm-3 col-2 align-self-center">
							<div class="top-menu-wrapper">
							    <div class="navigation_header">
							        <div class="toggle-nav mobile-menu">
							            <button onclick="business_assistant_openNav()">
							                <span class="dashicons dashicons-menu"></span>
							            </button>
							        </div>
							        <div id="mySidenav" class="nav sidenav">
							            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'business-assistant' ); ?>">
							                <?php {
							                    wp_nav_menu(
							                        array(
							                            'theme_location' => 'main-menu',
							                            'container_class' => 'navi clearfix navbar-nav',
							                            'menu_class'     => 'menu clearfix',
							                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							                            'fallback_cb'    => 'wp_page_menu',
							                        )
							                    );
							                } ?>
							            </nav>
							            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="business_assistant_closeNav()">
							                <span class="dashicons dashicons-no"></span>
							            </a>
							        </div>
							    </div>
							</div>
						</div>
						<div class="col-lg-3 col-md-6 col-sm-4 col-8 align-self-center">
							<?php if ( get_theme_mod('business_assistant_hotline_phone_text') || get_theme_mod('business_assistant_hotline_phone_number') ) : ?>
								<div class="row hotline-box">
									<div class="col-lg-3 col-md-3 col-sm-3 align-self-center">
										<i class="fas fa-phone"></i>
									</div>
									<div class="col-lg-9 col-md-9 col-sm-9 align-self-center">
		                        		<h6 class="mb-0"><?php echo esc_html( get_theme_mod('business_assistant_hotline_phone_text' ) ); ?></h6>
		                        		<p class="mb-0"><?php echo esc_html( get_theme_mod('business_assistant_hotline_phone_number' ) ); ?></p>
				                    </div>
								</div>
							<?php endif; ?>
						</div>
						<div class="col-lg-1 col-md-2 col-sm-5 col-2 align-self-center search-cart">
							<div class="offcanvas-div d-flex">
								<button type="button" data-bs-toggle="offcanvas" data-bs-target="#demo">
									<i class="fas fa-bars"></i>
								</button>
								<div class="offcanvas offcanvas-end" id="demo">
									<div class="offcanvas-header"> 
										<button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
									</div>
									<div class="offcanvas-body">
										<?php dynamic_sidebar('business-assistant-menu-sidebar'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</div>
</header>