<?php if ( get_theme_mod('business_assistant_blog_box_enable',false) ) : ?>

<?php $business_assistant_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('business_assistant_blog_slide_category'),
  'posts_per_page' => get_theme_mod('business_assistant_blog_slide_number'),
); ?>

<div class="slider">
  <div class="owl-carousel main-slider">
    <?php $business_assistant_arr_posts = new WP_Query( $business_assistant_args );
    if ( $business_assistant_arr_posts->have_posts() ) :
      while ( $business_assistant_arr_posts->have_posts() ) :
        $business_assistant_arr_posts->the_post();
        ?>
        <div class="blog_inner_box">
          <?php
            if ( has_post_thumbnail() ) :
              the_post_thumbnail();
            else:
              ?>
              <div class="slider-alternate">
                <img src="<?php echo esc_url( get_stylesheet_directory_uri() ). '/assets/images/banner.png'; ?>">
              </div>
              <?php
            endif;
          ?>
          <div class="blog_box">
            <div class="blog_box_inner wow zoomIn">
              <?php if ( get_theme_mod('business_assistant_slider_short_title') ) : ?>
                <h6><?php echo esc_html( get_theme_mod('business_assistant_slider_short_title' ) ); ?></h6>
              <?php endif; ?>
              <h3><?php the_title(); ?></h3>
              <p><?php echo wp_trim_words( get_the_content(), 25); ?></p>
              <p class="slider-button mt-4">
                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Shop Now','business-assistant'); ?><i class="fas fa-arrow-right ms-2"></i></a>
              </p>
            </div>
          </div>
        </div>
      <?php
    endwhile;
    wp_reset_postdata();
    endif; ?>
  </div>
</div>

<?php endif; ?>