<?php if ( get_theme_mod('business_assistant_about_us_section_enable', true) == true ) : ?>

  <section id="about" class="pt-5">
    <div class="container">
      <div class="row">
          <div class="col-lg-6 col-md-12 col-sm-12 align-self-center">
            <div class="row">
              <div class="col-lg-6 col-md-6 col-sm-12">
                <?php if ( get_theme_mod('business_assistant_about_us_section_image_1') ) : ?>
                    <img class="about-img-1 wow fadeInLeft" src="<?php echo esc_url(get_theme_mod('business_assistant_about_us_section_image_1')); ?>">
                <?php endif; ?>
                <?php if ( get_theme_mod('business_assistant_count_number') ) : ?>
                  <div class="count-detail wow fadeInUp">
                      <h3><?php echo esc_html(get_theme_mod('business_assistant_count_number')) ?></h3>
                      <p><?php esc_html_e( 'Year of Experience', 'business-assistant' ); ?></p>
                  </div>
                <?php endif; ?>
              </div>
              <div class="col-lg-6 col-md-6 col-sm-12">
                <?php if ( get_theme_mod('business_assistant_about_us_section_image_2') ) : ?>
                    <img class="about-img-2 mb-3 wow fadeInDown" src="<?php echo esc_url(get_theme_mod('business_assistant_about_us_section_image_2')); ?>">
                <?php endif; ?>
                <?php if ( get_theme_mod('business_assistant_about_us_section_image_3') ) : ?>
                    <img class="about-img-3 wow fadeInUp" src="<?php echo esc_url(get_theme_mod('business_assistant_about_us_section_image_3')); ?>">
                <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-12 col-sm-12 align-self-center wow fadeInRight">
            <?php if ( get_theme_mod('business_assistant_about_us_section_title') ) : ?>
              <h6><?php echo esc_html(get_theme_mod('business_assistant_about_us_section_title')) ?></h6>
            <?php endif; ?>
            <?php if ( get_theme_mod('business_assistant_about_us_main_section_title') ) : ?>
              <h3 class="my-3"><?php echo esc_html(get_theme_mod('business_assistant_about_us_main_section_title')) ?></h3>
            <?php endif; ?>
            <?php if ( get_theme_mod('business_assistant_about_us_section_content') ) : ?>
              <p class="my-3"><?php echo esc_html(get_theme_mod('business_assistant_about_us_section_content')) ?></p>
            <?php endif; ?>
            <div class="progress-box">
              <?php $business_assistant_progress_count = get_theme_mod('business_assistant_about_us_progress_count'); 
                for ($i=1; $i <= $business_assistant_progress_count; $i++) { ?>
                  <?php if ( get_theme_mod('business_assistant_about_us_progress_title'.$i) ) : ?>
                    <h3 class="progress-title"><?php echo esc_html( get_theme_mod('business_assistant_about_us_progress_title'.$i ) ); ?></h3>
                  <?php endif; ?>
                  <div class="progress">
                    <?php if ( get_theme_mod('business_assistant_about_us_progress_width'.$i) ) : ?>
                    <div class="progress-bar" style="width:<?php echo esc_html( get_theme_mod('business_assistant_about_us_progress_width'.$i ) ); ?>%; background:var(--first-color);">
                      <div class="progress-value"><?php echo esc_html( get_theme_mod('business_assistant_about_us_progress_width'.$i ) ); ?>%</div>
                    </div>
                    <?php endif; ?>
                  </div>
              <?php } ?>
            </div>
            <p class="slider-button mt-4">
              <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('More About Us','business-assistant'); ?><i class="fas fa-arrow-right ms-2"></i></a>
            </p>
          </div>
        <div class="clearfix"></div>
      </div>
    </div>
  </section>
<?php endif; ?>