<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_business_assistant_dismissed_notice_handler', 'business_assistant_ajax_notice_handler' );

function business_assistant_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function business_assistant_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_business-assistant-guide-page' &&
            $current_screen->id !== 'appearance_page_businessassistant-wizard'
        ) {
            $business_assistant_comments_theme = wp_get_theme();
            ?>
            <div class="business-assistant-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="business-assistant-notice">
                    <div class="business-assistant-notice-content">
                        <div class="business-assistant-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'business-assistant'); ?>
                                <?php echo esc_html( $business_assistant_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'business-assistant'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'business-assistant'),
                                    $business_assistant_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=business-assistant-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'business-assistant'); ?>
                            </a>
                            <a class="button button-primary" target="_blank" href="<?php echo esc_url( BUSINESS_ASSISTANT_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'business-assistant'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=businessassistant-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'business-assistant'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="business-assistant-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'business-assistant'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'business_assistant_deprecated_hook_admin_notice' );

add_action( 'admin_menu', 'business_assistant_getting_started' );
function business_assistant_getting_started() {
	add_theme_page( esc_html__('Get Started', 'business-assistant'), esc_html__('Get Started', 'business-assistant'), 'edit_theme_options', 'business-assistant-guide-page', 'business_assistant_test_guide');
}

function business_assistant_admin_enqueue_scripts() {
	wp_enqueue_style( 'business-assistant-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'business-assistant-admin-script', get_template_directory_uri() . '/js/business-assistant-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'business-assistant-admin-script', 'business_assistant_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'business_assistant_admin_enqueue_scripts' );

if ( ! defined( 'BUSINESS_ASSISTANT_DOCS_FREE' ) ) {
define('BUSINESS_ASSISTANT_DOCS_FREE',__('https://demo.misbahwp.com/docs/business-assistant-free-docs/','business-assistant'));
}
 if ( ! defined( 'BUSINESS_ASSISTANT_DOCS_PRO' ) ) {
define('BUSINESS_ASSISTANT_DOCS_PRO',__('https://demo.misbahwp.com/docs/business-assistant-pro-docs/','business-assistant'));
}
if ( ! defined( 'BUSINESS_ASSISTANT_BUY_NOW' ) ) {
define('BUSINESS_ASSISTANT_BUY_NOW',__('https://www.misbahwp.com/products/business-wordpress-theme','business-assistant'));
}
if ( ! defined( 'BUSINESS_ASSISTANT_SUPPORT_FREE' ) ) {
define('BUSINESS_ASSISTANT_SUPPORT_FREE',__('https://wordpress.org/support/theme/business-assistant','business-assistant'));
}
if ( ! defined( 'BUSINESS_ASSISTANT_REVIEW_FREE' ) ) {
define('BUSINESS_ASSISTANT_REVIEW_FREE',__('https://wordpress.org/support/theme/business-assistant/reviews/#new-post','business-assistant'));
}
if ( ! defined( 'BUSINESS_ASSISTANT_DEMO_PRO' ) ) {
define('BUSINESS_ASSISTANT_DEMO_PRO',__('https://demo.misbahwp.com/business-assistant/','business-assistant'));
}
if( ! defined( 'BUSINESS_ASSISTANT_THEME_BUNDLE' ) ) {
define('BUSINESS_ASSISTANT_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','business-assistant'));
}

function business_assistant_test_guide() { ?>
	<?php $business_assistant_theme = wp_get_theme(); ?>
	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( BUSINESS_ASSISTANT_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'business-assistant' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'business-assistant' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( BUSINESS_ASSISTANT_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'business-assistant' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( BUSINESS_ASSISTANT_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'business-assistant' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','business-assistant'); ?><?php echo esc_html( $business_assistant_theme ); ?>  <span><?php esc_html_e('Version: ', 'business-assistant'); ?><?php echo esc_html($business_assistant_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','business-assistant'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','business-assistant'); ?></p>
					<a class="button button-primary import" href="themes.php?page=businessassistant-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','business-assistant'); ?></a>
				</div>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $business_assistant_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$business_assistant_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $business_assistant_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="volleyball-postboxx">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'business-assistant' ); ?></h3>
				<div class="volleyball-insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','business-assistant'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( BUSINESS_ASSISTANT_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'business-assistant' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( BUSINESS_ASSISTANT_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'business-assistant' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( BUSINESS_ASSISTANT_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'business-assistant' ) ?></a>
					</div>
				</div>

				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'business-assistant' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'business-assistant'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','business-assistant'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','business-assistant'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','business-assistant'); ?></span></p>
				<div id="admin_pro_linkss">
					<a class="blue-button-1" href="<?php echo esc_url( BUSINESS_ASSISTANT_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Buy All Themes - $89', 'business-assistant' ) ?></a>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','business-assistant'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','business-assistant'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','business-assistant'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('LearnPress Campatiblity','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','business-assistant'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>

<?php } ?>