<?php

if ( class_exists("Kirki")){

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'business_assistant_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'business-assistant' ),
		'section'     => 'title_tagline',
		'default'     => 70,
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'business-assistant' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'business-assistant' ),
		'section'     => 'title_tagline',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'business_assistant_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'business-assistant' ),
	) );

	Kirki::add_section( 'business_assistant_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'business-assistant' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_all_headings_typography',
		'section'     => 'business_assistant_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'business_assistant_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'business-assistant' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'business-assistant' ),
		'section'     => 'business_assistant_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_body_content_typography',
		'section'     => 'business_assistant_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'business_assistant_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'business-assistant' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'business-assistant' ),
		'section'     => 'business_assistant_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'business_assistant_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'business-assistant' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'business_assistant_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'business-assistant' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'business-assistant' ),
		'section'     => 'business_assistant_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'business_assistant_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'business-assistant' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'business_assistant_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'business-assistant' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'business_assistant_dark_colors',
	    'section'     => 'business_assistant_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'business-assistant' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'business-assistant' ),
		'section'     => 'business_assistant_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'business_assistant_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings / No Result', 'business-assistant' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'business_assistant_section_404', array(
		'panel'          => 'business_assistant_panel_id_3',
	    'title'          => esc_html__( '404 Settings', 'business-assistant' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'business_assistant_404_heading',
	    'section'     => 'business_assistant_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Heading', 'business-assistant' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_404_page_title',
		'section'  => 'business_assistant_section_404',
		'default'  => esc_html__('404 Not Found', 'business-assistant'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'business_assistant_404_text',
	    'section'     => 'business_assistant_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Content', 'business-assistant' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_404_page_content',
		'section'  => 'business_assistant_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'business-assistant'),
		'priority' => 10,
	] );

	// NO Result
	Kirki::add_section( 'business_assistant_no_result', array(
		'panel'          => 'business_assistant_panel_id_3',
	    'title'          => esc_html__( 'No Result Page Settings', 'business-assistant' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_no_result',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'business_assistant_not_found_heading',
	    'section'     => 'business_assistant_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Heading', 'business-assistant' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_no_results_page_title',
		'section'  => 'business_assistant_no_result',
		'default'  => esc_html__('404 Not Found', 'business-assistant'),
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'business_assistant_not_found_text',
	    'section'     => 'business_assistant_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Content', 'business-assistant' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_no_results_page_content',
		'section'  => 'business_assistant_no_result',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'business-assistant'),
		'priority' => 10,
	] );


	// PANEL

	Kirki::add_panel( 'business_assistant_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'business-assistant' ),
	) );

	//COLOR SECTION

	Kirki::add_section( 'business_assistant_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'business-assistant' ),
	    'panel'          => 'business_assistant_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_global_colors',
		'section'     => 'business_assistant_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'business_assistant_first_color',
		'label'       => __( 'Choose Your First Color', 'business-assistant' ),
		'section'     => 'business_assistant_section_color',
		'default'     => '#4482f6',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'business_assistant_second_color',
		'label'       => __( 'Choose Your Second Color', 'business-assistant' ),
		'section'     => 'business_assistant_section_color',
		'default'     => '#212121',
	] );

	// Additional Settings

	Kirki::add_section( 'business_assistant_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'business-assistant' ),
	    'panel'          => 'business_assistant_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'business_assistant_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'business-assistant' ),
		'section'     => 'business_assistant_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'business_assistant_scroll_top_position',
			'label'       => esc_html__( 'Alignment for Scroll To Top', 'business-assistant' ),
			'section'     => 'business_assistant_additional_settings',
			'default'     => 'Right',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'business-assistant' ),
				'Center' => esc_html__( 'Center', 'business-assistant' ),
				'Right'  => esc_html__( 'Right', 'business-assistant' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'business_assistant_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'business-assistant' ),
		'section'  => 'business_assistant_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
		[
			'settings'    => 'menu_text_transform_business_assistant',
			'label'       => esc_html__( 'Menus Text Transform', 'business-assistant' ),
			'section'     => 'business_assistant_additional_settings',
			'default'     => 'CAPITALISE',
			'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
			'choices'     => [
				'CAPITALISE' => esc_html__( 'CAPITALISE', 'business-assistant' ),
				'UPPERCASE' => esc_html__( 'UPPERCASE', 'business-assistant' ),
				'LOWERCASE' => esc_html__( 'LOWERCASE', 'business-assistant' ),

			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'business_assistant_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'business-assistant' ),
		'section'     => 'business_assistant_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'business_assistant_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'business-assistant' ),
		'section'     => 'business_assistant_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'business-assistant' ),
		'section'     => 'business_assistant_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','business-assistant'),
            'cube-loader' => __('Type 2','business-assistant'),
		],
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'business-assistant' ),
		'section'     => 'business_assistant_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','business-assistant'),
            'Right Sidebar' => __('Right Sidebar','business-assistant'),
            'One Column' => __('One Column','business-assistant')
		],
	] );

	if ( class_exists("woocommerce")){

		// Woocommerce Settings

		Kirki::add_section( 'business_assistant_woocommerce_settings', array(
				'title'          => esc_html__( 'Woocommerce Settings', 'business-assistant' ),
				'panel'          => 'business_assistant_panel_id',
				'priority'       => 160,
		) );

		Kirki::add_field( 'theme_config_id', [
		    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
		    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
		    'type'        => 'custom',
		    'section'     => 'business_assistant_woocommerce_settings',
		    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'business_assistant_shop_sidebar',
			'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'business-assistant' ),
			'section'     => 'business_assistant_woocommerce_settings',
			'default'     => '1',
			'priority'    => 10,
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'business_assistant_product_sidebar',
			'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'business-assistant' ),
			'section'     => 'business_assistant_woocommerce_settings',
			'default'     => '1',
			'priority'    => 10,
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'business_assistant_related_product_setting',
			'label'       => esc_html__( 'Here you can enable or disable your related products.', 'business-assistant' ),
			'section'     => 'business_assistant_woocommerce_settings',
			'default'     => true,
			'priority'    => 10,
		] );

		new \Kirki\Field\Number(
			[
				'settings' => 'business_assistant_per_columns',
				'label'    => esc_html__( 'Product Per Row', 'business-assistant' ),
				'section'  => 'business_assistant_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 4,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Number(
			[
				'settings' => 'business_assistant_product_per_page',
				'label'    => esc_html__( 'Product Per Page', 'business-assistant' ),
				'section'  => 'business_assistant_woocommerce_settings',
				'default'  => 9,
				'choices'  => [
					'min'  => 1,
					'max'  => 15,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Number(
			[
				'settings' => 'custom_related_products_number_per_row',
				'label'    => esc_html__( 'Related Product Per Column', 'business-assistant' ),
				'section'  => 'business_assistant_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 4,
					'step' => 1,
				],
			]
		);

	new \Kirki\Field\Number(
			[
				'settings' => 'custom_related_products_number',
				'label'    => esc_html__( 'Related Product Per Page', 'business-assistant' ),
				'section'  => 'business_assistant_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 10,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Select(
		[
			'settings'    => 'business_assistant_shop_page_layout',
			'label'       => esc_html__( 'Shop Page Layout Setting', 'business-assistant' ),
			'section'     => 'business_assistant_woocommerce_settings',
			'default' => 'Right Sidebar',
			'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
			'choices'     => [
				'Left Sidebar' => __('Left Sidebar','business-assistant'),
	            'Right Sidebar' => __('Right Sidebar','business-assistant')
			],
		] );

		new \Kirki\Field\Select(
		[
			'settings'    => 'business_assistant_product_page_layout',
			'label'       => esc_html__( 'Product Page Layout Setting', 'business-assistant' ),
			'section'     => 'business_assistant_woocommerce_settings',
			'default' => 'Right Sidebar',
			'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
			'choices'     => [
				'Left Sidebar' => __('Left Sidebar','business-assistant'),
	            'Right Sidebar' => __('Right Sidebar','business-assistant')
			],
		] );

		new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'business_assistant_woocommerce_pagination_position',
			'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'business-assistant' ),
			'section'     => 'business_assistant_woocommerce_settings',
			'default'     => 'Center',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'business-assistant' ),
				'Center' => esc_html__( 'Center', 'business-assistant' ),
				'Right'  => esc_html__( 'Right', 'business-assistant' ),
			],
		]
		);
	}

	// POST SECTION

	Kirki::add_section( 'business_assistant_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'business-assistant' ),
	    'panel'          => 'business_assistant_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'business_assistant_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'business-assistant' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'business-assistant' ),
		'section'  => 'business_assistant_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'business-assistant' ),
			'option2' => esc_html__( 'Post Meta', 'business-assistant' ),
			'option3' => esc_html__( 'Post Title', 'business-assistant' ),
			'option4' => esc_html__( 'Post Content', 'business-assistant' ),
			'option5' => esc_html__( 'Post Button', 'business-assistant' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'business_assistant_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'business-assistant' ),
		'section'     => 'business_assistant_section_post',
		'default'     => 10,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'business_assistant_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'business-assistant' ),
		'section'     => 'business_assistant_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'business-assistant' ),
		'section'     => 'business_assistant_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','business-assistant'),
            'Right Sidebar' => __('Right Sidebar','business-assistant'),
            'Three Column' => __('Three Column','business-assistant'),
            'Four Column' => __('Four Column','business-assistant'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','business-assistant'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','business-assistant'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','business-assistant')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'business-assistant' ),
		'section'     => 'business_assistant_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','business-assistant'),
            'Right Sidebar' => __('Right Sidebar','business-assistant'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'business-assistant' ),
		'section'     => 'business_assistant_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','business-assistant'),
            'Right Sidebar' => __('Right Sidebar','business-assistant'),
            'Three Column' => __('Three Column','business-assistant'),
            'Four Column' => __('Four Column','business-assistant'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','business-assistant'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','business-assistant'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','business-assistant')
		],
	] );

	// Breadcrumb
	Kirki::add_section( 'business_assistant_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'business-assistant' ),
	    'panel'          => 'business_assistant_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_breadcrumb_heading',
		'section'     => 'business_assistant_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'business-assistant' ),
		'section'     => 'business_assistant_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'business_assistant_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'business-assistant' ),
        'section'  => 'business_assistant_bradcrumb',
    ] );

	// HEADER SECTION

	Kirki::add_section( 'business_assistant_section_header', array(
	    'title'          => esc_html__( 'Header Settings', 'business-assistant' ),
	    'panel'          => 'business_assistant_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_section_header',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_phone_heading',
		'section'     => 'business_assistant_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Phone Number', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_header_phone_number',
		'section'  => 'business_assistant_section_header',
		'priority' => 10,
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_email_heading',
		'section'     => 'business_assistant_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Email Address', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_header_email_address',
		'section'  => 'business_assistant_section_header',
		'priority' => 10,
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_location_heading',
		'section'     => 'business_assistant_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Location', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_header_address_location',
		'section'  => 'business_assistant_section_header',
		'priority' => 10,
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_hotline_heading',
		'section'     => 'business_assistant_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Hot Line Number', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Text', 'business-assistant' ),
		'settings' => 'business_assistant_hotline_phone_text',
		'section'  => 'business_assistant_section_header',
		'priority' => 10,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Hot Line Number', 'business-assistant' ),
		'settings' => 'business_assistant_hotline_phone_number',
		'section'  => 'business_assistant_section_header',
		'priority' => 10,
    ] );
 
	// SLIDER SECTION

	Kirki::add_section( 'business_assistant_blog_slide_section', array(
        'title'          => esc_html__( ' Slider Settings', 'business-assistant' ),
        'panel'          => 'business_assistant_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_blog_slide_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_heading',
		'section'     => 'business_assistant_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_blog_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'business-assistant' ),
		'section'     => 'business_assistant_blog_slide_section',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_slider_heading',
		'section'     => 'business_assistant_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Main Slider', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'business_assistant_blog_slide_number',
		'label'       => esc_html__( 'Number of slides to show', 'business-assistant' ),
		'section'     => 'business_assistant_blog_slide_section',
		'default'     => 3,
		'choices'     => [
			'min'  => 0,
			'max'  => 3,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'business_assistant_blog_slide_category',
		'description'    => esc_html__( 'You have to select post category to show slider.', 'business-assistant' ),
		'label'       => esc_html__( 'Select the category to show slider ( Image Dimension 750 x 450 )', 'business-assistant' ),
		'section'     => 'business_assistant_blog_slide_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'business-assistant' ),
		'priority'    => 10,
		'choices'     => business_assistant_get_categories_select(),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Slider Sub Title', 'business-assistant' ),
		'settings' => 'business_assistant_slider_short_title',
		'section'  => 'business_assistant_blog_slide_section',
		'priority' => 10,
    ] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_slider_content_alignment',
		'label'       => esc_html__( 'Slider Content Alignment', 'business-assistant' ),
		'section'     => 'business_assistant_blog_slide_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'business-assistant' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'business-assistant' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'business-assistant' ),

		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_slider_opacity_color',
		'label'       => esc_html__( 'Slider Opacity Option', 'business-assistant' ),
		'section'     => 'business_assistant_blog_slide_section',
		'default'     => '1.0',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'0' => esc_html__( '0', 'business-assistant' ),
			'0.1' => esc_html__( '0.1', 'business-assistant' ),
			'0.2' => esc_html__( '0.2', 'business-assistant' ),
			'0.3' => esc_html__( '0.3', 'business-assistant' ),
			'0.4' => esc_html__( '0.4', 'business-assistant' ),
			'0.5' => esc_html__( '0.5', 'business-assistant' ),
			'0.6' => esc_html__( '0.6', 'business-assistant' ),
			'0.7' => esc_html__( '0.7', 'business-assistant' ),
			'0.8' => esc_html__( '0.8', 'business-assistant' ),
			'0.9' => esc_html__( '0.9', 'business-assistant' ),
			'1.0' => esc_html__( '1.0', 'business-assistant' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_overlay_option',
		'label'       => esc_html__( 'Enable / Disable Slider Overlay', 'business-assistant' ),
		'section'     => 'business_assistant_blog_slide_section',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );


	// ABOUT US SECTION

	Kirki::add_section( 'business_assistant_about_us_section', array(
        'title'          => esc_html__( 'About Us Settings', 'business-assistant' ),
        'panel'          => 'business_assistant_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_about_us_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_about_us_section_enable_heading',
		'section'     => 'business_assistant_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable About Us Section', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_about_us_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'business-assistant' ),
		'section'     => 'business_assistant_about_us_section',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_about_us_section_title_heading',
		'section'     => 'business_assistant_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Section Title', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_about_us_section_title',
		'section'  => 'business_assistant_about_us_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_about_us_section_title_headingss',
		'section'     => 'business_assistant_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Section Main Title', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_about_us_main_section_title',
		'section'  => 'business_assistant_about_us_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_about_us_section_title_headingsss',
		'section'     => 'business_assistant_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Section Content', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_about_us_section_content',
		'section'  => 'business_assistant_about_us_section',
		'default'  => '',
		'priority' => 10,
	] );

	 new \Kirki\Field\Image(
		[
			'settings'    => 'business_assistant_about_us_section_image_1',
			'label'       => esc_html__( 'Image 1', 'business-assistant' ),
			'description' => esc_html__( 'About Experience Image.', 'business-assistant' ),
			'section'     => 'business_assistant_about_us_section',
			'default'     => '',
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_about_count_number_headingsss',
		'section'     => 'business_assistant_about_us_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Years of Experience', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_count_number',
		'section'  => 'business_assistant_about_us_section',
		'default'  => '',
		'priority' => 10,
	] );

	 new \Kirki\Field\Image(
		[
			'settings'    => 'business_assistant_about_us_section_image_2',
			'label'       => esc_html__( 'Image 2', 'business-assistant' ),
			'description' => esc_html__( 'About section second Image.', 'business-assistant' ),
			'section'     => 'business_assistant_about_us_section',
			'default'     => '',
		]
	);


	  new \Kirki\Field\Image(
		[
			'settings'    => 'business_assistant_about_us_section_image_3',
			'label'       => esc_html__( 'Image 3', 'business-assistant' ),
			'description' => esc_html__( 'About section third Image', 'business-assistant' ),
			'section'     => 'business_assistant_about_us_section',
			'default'     => '',
		]
	);


	new \Kirki\Field\Number(
		[
			'settings' => 'business_assistant_about_us_progress_count',
			'label'    => esc_html__( 'Progress Number Control', 'business-assistant' ),
			'section'  => 'business_assistant_about_us_section',
			'default'  => '',
			'choices'  => [
				'min'  => 0,
				'max'  => 3,
				'step' => 1,
			],
		]
	);

	$business_assistant_progress_count = get_theme_mod('business_assistant_about_us_progress_count');

	for ($i=1; $i <= $business_assistant_progress_count; $i++) { 
		
		new \Kirki\Field\Text(
			[
				'settings' => 'business_assistant_about_us_progress_title'.$i,
				'label'    => esc_html__( 'Progress Title 0', 'business-assistant' ).$i,
				'section'  => 'business_assistant_about_us_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'business_assistant_about_us_progress_width'.$i,
				'label'    => esc_html__( 'Progress Percentage', 'business-assistant' ).$i,
				'section'  => 'business_assistant_about_us_section',
			]
		);

	}

	// FOOTER SECTION

	Kirki::add_section( 'business_assistant_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'business-assistant' ),
        'panel'          => 'business_assistant_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'business-assistant' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( BUSINESS_ASSISTANT_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'business-assistant' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'business_assistant_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'business-assistant' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_footer_enable_heading',
		'section'     => 'business_assistant_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'business_assistant_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'business-assistant' ),
		'section'     => 'business_assistant_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'business-assistant' ),
			'off' => esc_html__( 'Disable', 'business-assistant' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_footer_text_heading',
		'section'     => 'business_assistant_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'business-assistant' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'business_assistant_footer_text',
		'section'  => 'business_assistant_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'business_assistant_footer_text_heading_2',
	'section'     => 'business_assistant_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'business-assistant' ) . '</h3>',
	'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'business_assistant_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'business-assistant' ),
		'section'     => 'business_assistant_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'business-assistant' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'business-assistant' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'business-assistant' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'business-assistant' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'business_assistant_footer_text_heading_1',
	'section'     => 'business_assistant_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'business-assistant' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'business_assistant_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'business-assistant' ),
		'section'     => 'business_assistant_footer_section',
		'default'     => '#000000',
	] );

		Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'business_assistant_enable_footer_socail_link',
		'section'     => 'business_assistant_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'business-assistant' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'business_assistant_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'business-assistant' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'business-assistant' ),
		'settings'     => 'business_assistant_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'business-assistant' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'business-assistant' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'business-assistant' ),
				'description' => esc_html__( 'Add the social icon url here.', 'business-assistant' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}


add_action( 'customize_register', 'business_assistant_customizer_settings' );
function business_assistant_customizer_settings( $wp_customize ) {

	$business_assistant_args = array(
	       'type'                     => 'product',
	        'child_of'                 => 0,
	        'parent'                   => '',
	        'orderby'                  => 'term_group',
	        'order'                    => 'ASC',
	        'hide_empty'               => false,
	        'hierarchical'             => 1,
	        'number'                   => '',
	        'taxonomy'                 => 'product_cat',
	        'pad_counts'               => false
	    );
		$categories = get_categories($business_assistant_args);
		$daily_deals_cat_posts = array();
		$m = 0;
		$daily_deals_cat_posts[]='Select';
		foreach($categories as $category){
			if($m==0){
				$default = $category->slug;
				$m++;
			}
			$daily_deals_cat_posts[$category->slug] = $category->name;
		}

		$wp_customize->add_setting('business_assistant_daily_deals_product_category',array(
			'default'	=> 'select',
			'sanitize_callback' => 'business_assistant_sanitize_select',
		));
		$wp_customize->add_control('business_assistant_daily_deals_product_category',array(
			'type'    => 'select',
			'choices' => $daily_deals_cat_posts,
			'label' => __('Select category to display products ','business-assistant'),
			'section' => 'business_assistant_our_product_section',
			'priority' => 3,
		));

	$wp_customize->add_setting('business_assistant_our_product_tab_number',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('business_assistant_our_product_tab_number',array(
		'type' => 'number',
		'label' => __('Show number of product tab','business-assistant'),
		'section' => 'business_assistant_our_product_section',
	));

	$business_assistant_product_post = get_theme_mod('business_assistant_our_product_tab_number','');
    for ( $business_assistant_j = 1; $business_assistant_j <= $business_assistant_product_post; $business_assistant_j++ ) {

		$wp_customize->add_setting('business_assistant_our_product_tabs_text'.$business_assistant_j,array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control('business_assistant_our_product_tabs_text'.$business_assistant_j,array(
			'type' => 'text',
			'label' => __('Tab Text ','business-assistant').$business_assistant_j,
			'section' => 'business_assistant_our_product_section',
		));

		$business_assistant_args = array(
	       'type'                     => 'product',
	        'child_of'                 => 0,
	        'parent'                   => '',
	        'orderby'                  => 'term_group',
	        'order'                    => 'ASC',
	        'hide_empty'               => false,
	        'hierarchical'             => 1,
	        'number'                   => '',
	        'taxonomy'                 => 'product_cat',
	        'pad_counts'               => false
	    );
		$categories = get_categories($business_assistant_args);
		$business_assistant_cat_posts = array();
		$business_assistant_m = 0;
		$business_assistant_cat_posts[]='Select';
		foreach($categories as $category){
			if($business_assistant_m==0){
				$default = $category->slug;
				$business_assistant_m++;
			}
			$business_assistant_cat_posts[$category->slug] = $category->name;
		}

		$wp_customize->add_setting('business_assistant_our_product_category'.$business_assistant_j,array(
			'default'	=> 'select',
			'sanitize_callback' => 'business_assistant_sanitize_select',
		));

		$wp_customize->add_control('business_assistant_our_product_category'.$business_assistant_j,array(
			'type'    => 'select',
			'choices' => $business_assistant_cat_posts,
			'label' => __('Select category to display products ','business-assistant').$business_assistant_j,
			'section' => 'business_assistant_our_product_section',
		));
	}
}

/*
 *  Customizer Notifications
 */

$business_assistant_config_customizer = array(
    'recommended_plugins' => array( 
        'kirki' => array(
            'recommended' => true,
             'description' => sprintf( 
                /* translators: %s: plugin name */
                esc_html__( 'If you want to show all the sections of the FrontPage, please install and activate %s plugin', 'business-assistant' ), 
                '<strong>' . esc_html__( 'Kirki Customizer', 'business-assistant' ) . '</strong>'
            ),
        ),
    ),
    'business_assistant_recommended_actions'       => array(),
    'business_assistant_recommended_actions_title' => esc_html__( 'Recommended Actions', 'business-assistant' ),
    'business_assistant_recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'business-assistant' ),
    'business_assistant_install_button_label'      => esc_html__( 'Install and Activate', 'business-assistant' ),
    'business_assistant_activate_button_label'     => esc_html__( 'Activate', 'business-assistant' ),
    'business_assistant_deactivate_button_label'   => esc_html__( 'Deactivate', 'business-assistant' ),
);

business_assistant_Customizer_Notify::init( apply_filters( 'business_assistant_customizer_notify_array', $business_assistant_config_customizer ) );