<?php

class business_assistant_Customizer_Notify {

	private $config = array(); // Declare $config property
	
	private $business_assistant_recommended_actions;
	
	private $recommended_plugins;
	
	private static $instance;
	
	private $business_assistant_recommended_actions_title;
	
	private $business_assistant_recommended_plugins_title;
	
	private $dismiss_button;
	
	private $business_assistant_install_button_label;
	
	private $business_assistant_activate_button_label;
	
	private $business_assistant_deactivate_button_label;

	
	public static function init( $config ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof business_assistant_Customizer_Notify ) ) {
			self::$instance = new business_assistant_Customizer_Notify;
			if ( ! empty( $config ) && is_array( $config ) ) {
				self::$instance->config = $config;
				self::$instance->setup_config();
				self::$instance->setup_actions();
			}
		}

	}

	
	public function setup_config() {

		global $business_assistant_customizer_notify_recommended_plugins;
		global $business_assistant_customizer_notify_business_assistant_recommended_actions;

		global $business_assistant_install_button_label;
		global $business_assistant_activate_button_label;
		global $business_assistant_deactivate_button_label;

		$this->business_assistant_recommended_actions = isset( $this->config['business_assistant_recommended_actions'] ) ? $this->config['business_assistant_recommended_actions'] : array();
		$this->recommended_plugins = isset( $this->config['recommended_plugins'] ) ? $this->config['recommended_plugins'] : array();

		$this->business_assistant_recommended_actions_title = isset( $this->config['business_assistant_recommended_actions_title'] ) ? $this->config['business_assistant_recommended_actions_title'] : '';
		$this->business_assistant_recommended_plugins_title = isset( $this->config['business_assistant_recommended_plugins_title'] ) ? $this->config['business_assistant_recommended_plugins_title'] : '';
		$this->dismiss_button            = isset( $this->config['dismiss_button'] ) ? $this->config['dismiss_button'] : '';

		$business_assistant_customizer_notify_recommended_plugins = array();
		$business_assistant_customizer_notify_business_assistant_recommended_actions = array();

		if ( isset( $this->recommended_plugins ) ) {
			$business_assistant_customizer_notify_recommended_plugins = $this->recommended_plugins;
		}

		if ( isset( $this->business_assistant_recommended_actions ) ) {
			$business_assistant_customizer_notify_business_assistant_recommended_actions = $this->business_assistant_recommended_actions;
		}

		$business_assistant_install_button_label    = isset( $this->config['business_assistant_install_button_label'] ) ? $this->config['business_assistant_install_button_label'] : '';
		$business_assistant_activate_button_label   = isset( $this->config['business_assistant_activate_button_label'] ) ? $this->config['business_assistant_activate_button_label'] : '';
		$business_assistant_deactivate_button_label = isset( $this->config['business_assistant_deactivate_button_label'] ) ? $this->config['business_assistant_deactivate_button_label'] : '';

	}

	
	public function setup_actions() {

		// Register the section
		add_action( 'customize_register', array( $this, 'business_assistant_plugin_notification_customize_register' ) );

		// Enqueue scripts and styles
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'business_assistant_customizer_notify_scripts_for_customizer' ), 0 );

		/* ajax callback for dismissable recommended actions */
		add_action( 'wp_ajax_quality_customizer_notify_dismiss_action', array( $this, 'business_assistant_customizer_notify_dismiss_recommended_action_callback' ) );

		add_action( 'wp_ajax_ti_customizer_notify_dismiss_recommended_plugins', array( $this, 'business_assistant_customizer_notify_dismiss_recommended_plugins_callback' ) );

	}

	
	public function business_assistant_customizer_notify_scripts_for_customizer() {

		wp_enqueue_style( 'business-assistant-customizer-notify-css', get_template_directory_uri() . '/core/includes/customizer-notice/css/business-assistant-customizer-notify.css', array());

		wp_enqueue_style( 'plugin-install' );
		wp_enqueue_script( 'plugin-install' );
		wp_add_inline_script( 'plugin-install', 'var pagenow = "customizer";' );

		wp_enqueue_script( 'updates' );

		wp_enqueue_script( 'business-assistant-customizer-notify-js', get_template_directory_uri() . '/core/includes/customizer-notice/js/business-assistant-customizer-notify.js', array( 'customize-controls' ));
		wp_localize_script(
			'business-assistant-customizer-notify-js', 'businessassistantCustomizercompanionObject', array(
				'ajaxurl'            => admin_url( 'admin-ajax.php' ),
				'template_directory' => get_template_directory_uri(),
				'base_path'          => admin_url(),
				'activating_string'  => __( 'Activating', 'business-assistant' ),
			)
		);

	}

	
	public function business_assistant_plugin_notification_customize_register( $wp_customize ) {

		
		require_once get_template_directory() . '/core/includes/customizer-notice/business-assistant-customizer-notify-section.php';

		$wp_customize->register_section_type( 'business_assistant_Customizer_Notify_Section' );

		$wp_customize->add_section(
			new business_assistant_Customizer_Notify_Section(
				$wp_customize,
				'business-assistant-customizer-notify-section',
				array(
					'title'          => $this->business_assistant_recommended_actions_title,
					'plugin_text'    => $this->business_assistant_recommended_plugins_title,
					'dismiss_button' => $this->dismiss_button,
					'priority'       => 0,
				)
			)
		);

	}

	
	public function business_assistant_customizer_notify_dismiss_recommended_action_callback() {

		global $business_assistant_customizer_notify_business_assistant_recommended_actions;

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */ 

		if ( ! empty( $action_id ) ) {
			
			if ( get_option( 'business_assistant_customizer_notify_show' ) ) {

				$business_assistant_customizer_notify_show_business_assistant_recommended_actions = get_option( 'business_assistant_customizer_notify_show' );
				switch ( $_GET['todo'] ) {
					case 'add':
						$business_assistant_customizer_notify_show_business_assistant_recommended_actions[ $action_id ] = true;
						break;
					case 'dismiss':
						$business_assistant_customizer_notify_show_business_assistant_recommended_actions[ $action_id ] = false;
						break;
				}
				update_option( 'business_assistant_customizer_notify_show', $business_assistant_customizer_notify_show_business_assistant_recommended_actions );

				
			} else {
				$business_assistant_customizer_notify_show_business_assistant_recommended_actions = array();
				if ( ! empty( $business_assistant_customizer_notify_business_assistant_recommended_actions ) ) {
					foreach ( $business_assistant_customizer_notify_business_assistant_recommended_actions as $business_assistant_lite_customizer_notify_recommended_action ) {
						if ( $business_assistant_lite_customizer_notify_recommended_action['id'] == $action_id ) {
							$business_assistant_customizer_notify_show_business_assistant_recommended_actions[ $business_assistant_lite_customizer_notify_recommended_action['id'] ] = false;
						} else {
							$business_assistant_customizer_notify_show_business_assistant_recommended_actions[ $business_assistant_lite_customizer_notify_recommended_action['id'] ] = true;
						}
					}
					update_option( 'business_assistant_customizer_notify_show', $business_assistant_customizer_notify_show_business_assistant_recommended_actions );
				}
			}
		}
		die(); 
	}

	
	public function business_assistant_customizer_notify_dismiss_recommended_plugins_callback() {

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */

		if ( ! empty( $action_id ) ) {

			$business_assistant_lite_customizer_notify_show_recommended_plugins = get_option( 'business_assistant_customizer_notify_show_recommended_plugins' );

			switch ( $_GET['todo'] ) {
				case 'add':
					$business_assistant_lite_customizer_notify_show_recommended_plugins[ $action_id ] = false;
					break;
				case 'dismiss':
					$business_assistant_lite_customizer_notify_show_recommended_plugins[ $action_id ] = true;
					break;
			}
			update_option( 'business_assistant_customizer_notify_show_recommended_plugins', $business_assistant_lite_customizer_notify_show_recommended_plugins );
		}
		die(); 
	}

}
