<?php
/**
 * Template part for displaying WooCommerce Cart
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Business_Aarambha
 */

$wc_cart_icon = get_theme_mod(
    'business_aarambha_header_woocommerce_cart_icon',
    ['desktop'=> 'fa-shopping-cart']
);
$widget_class = is_cart() ? 'wc-cart-widget-wrapper d-none' : 'wc-cart-widget-wrapper';
?>
<div class="header-wc-cart-wrap d-flex">
    <div class="wc-cart-wrapper">
        <a class="wc-icon cart-icon" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'business-aarambha' ); ?>">
            <i class="fa <?php echo esc_attr($wc_cart_icon['desktop']); ?>" aria-hidden="true"></i>
            <span class="cart-value"> <?php echo wp_kses_data( WC()->cart->get_cart_contents_count() ); ?></span>
        </a>
        <div class="<?php echo esc_attr( $widget_class ); ?>">
            <?php $instance = array(
                'title' => esc_html__( 'Your Cart', 'business-aarambha' ),
            );
            the_widget( 'WC_Widget_Cart', $instance ); ?>
        </div>
    </div>
</div><!-- .header-wc-cart-wrap -->