<?php
/**
 * Template part for displaying front page header banner slider content
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Business_Aarambha
 */

$banner_type = get_theme_mod( 'business_aarambha_header_banner_type', ['desktop' => 'banner'] );

if ( $banner_type && $banner_type['desktop'] != 'none' ) :

    // Arguments
    $args = [
        'post_type'             => 'post',
        'posts_per_page'        => 1,
        'post_status'           => 'publish',
        'ignore_sticky_posts'   => true,
        'no_found_rows'         => true
    ];
    // slider args
    if ( $banner_type['desktop'] == 'slider' ) {
        $slider_cats = get_theme_mod(
            'business_aarambha_header_banner_slider_cat',
            ''
        );
        if ( $slider_cats ) {
            $args['category__in'] = absint($slider_cats);
        }
        $slides_limit = get_theme_mod(
            'business_aarambha_header_banner_slider_limit',
            ['desktop' => 3 ]
        );
        if ( $slides_limit ) {
            $args['posts_per_page'] = absint($slides_limit['desktop']);
        }
    }
    // single post args
    elseif ( $banner_type['desktop'] == 'banner' ) {
        $banner_id = get_theme_mod(
            'business_aarambha_header_banner_post_id',
            ''
        );
        $args['p']    = absint($banner_id);
    }

    $the_query = new WP_Query( $args );

    if ( $the_query->have_posts() ) :

        // Content Elements
        $content_elements = get_theme_mod('business_aarambha_banner_post_content_elements', ['post-title','post-excerpt','read-more'] );
        ?>

        <section class="header-banner-section">
            <div class="banner-slider">
                <?php while ( $the_query->have_posts() ) : $the_query->the_post();
                /* grab the url for the banner-1200-16x9 size featured image */
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'banner-1200-16x9'); ?>

                    <div class="slider-item"<?php if ( has_post_thumbnail() ) { echo ' style="background-image: url(' . esc_url( $featured_img_url ) . ')"'; }?>>
                    
                        <?php if ( ! empty( $content_elements ) ) : ?>

                            <div class="d-flex justify-content-left slider-text">
                                <div class="post">
                                    <div class="d-flex flex-column post-detail-wrap">

                                        <?php foreach ( $content_elements as $element ) :

                                            switch ( $element ) :

                                                case 'post-title' :
                                                    Business_Aarambha_Helper::banner_post_title();
                                                    break;

                                                case 'post-excerpt' :
                                                    echo '<div class="entry-content">';
                                                    Business_Aarambha_Helper::post_excerpt();
                                                    echo '</div>';
                                                    break;

                                                case 'read-more' :
                                                    Business_Aarambha_Helper::banner_read_more();
                                                    break;

                                            endswitch;
                                        endforeach;?>
                                    </div>
                                </div><!-- .post -->
                            </div><!-- .slider-text -->

                        <?php endif; ?>

                    </div><!-- .slider-item -->
                    <?php wp_reset_postdata(); ?>
                <?php endwhile; ?>
            </div><!-- .banner-slider -->
        </section><!-- .header-banner-section -->

    <?php
    endif;
endif;
