<?php
/**
 * Plugin recommendation
 *
 * @package Business_Aarambha
 */

// Load TGM library.
require BUSINESS_AARAMBHA_DIR . 'inc/tgm/class-tgm-plugin-activation.php';

if ( ! function_exists( 'business_aarambha_recommended_plugins' ) ) :

	/**
	 * Register recommended plugins.
	 *
	 * @since 1.0.0
	 */
	function business_aarambha_recommended_plugins() {
        $plugins = array(
            array(
                'name'     => esc_html__( 'Aarambha Demo Sites', 'business-aarambha' ),
                'slug'     => 'aarambha-demo-sites',
                'required' => false,
            ),
            array(
                'name'     => esc_html__( 'Elementor Page Builder', 'business-aarambha' ),
                'slug'     => 'elementor',
                'required' => false,
            )
        );

        $config = array();

        tgmpa( $plugins, $config );
	}

endif;

add_action( 'tgmpa_register', 'business_aarambha_recommended_plugins' );
