<?php
/**
 * Business Aarambha hooks
 *
 * @package Business_Aarambha
 */

/* ------------------------------ HEADER ------------------------------ */
/**
 * Meta head.
 *
 * @see business_aarambha_head_meta()
 */
add_action( 'business_aarambha_head', 'business_aarambha_head_meta', 10 );


/**
 * Header Bottom Content
 *
 * @see business_aarambha_header_banner()
 * @see business_aarambha_header_page_top_content()
 */
add_action( 'business_aarambha_header_bottom', 'business_aarambha_header_banner', 10 );
add_action( 'business_aarambha_header_bottom', 'business_aarambha_header_page_top_content', 15 );



/* ------------------------------ BEFORE CONTENT ------------------------------ */
/**
 * Before Content of page
 *
 * @see business_aarambha_site_content_start()
 * @see business_aarambha_page_section_start()
 * @see business_aarambha_page_container_start()
 */
add_action( 'business_aarambha_content_before', 'business_aarambha_site_content_start', 5 );
add_action( 'business_aarambha_content_before', 'business_aarambha_page_section_start', 10 );
add_action( 'business_aarambha_content_before', 'business_aarambha_page_container_start', 15 );

/* ------------------------------ AFTER CONTENT ------------------------------ */
/**
 * After Content of page
 *
 * @see business_aarambha_page_container_end()
 * @see business_aarambha_page_section_end()
 * @see business_aarambha_site_content_end()
 */
add_action( 'business_aarambha_content_after', 'business_aarambha_page_container_end', 5 );
add_action( 'business_aarambha_content_after', 'business_aarambha_page_section_end', 10 );
add_action( 'business_aarambha_content_after', 'business_aarambha_site_content_end', 15 );

/* ------------------------------ BLOG/ARCHIVE PAGE ------------------------------ */

/**
 * After content loop
 *
 * @see business_aarambha_posts_navigation()
 */
add_action( 'business_aarambha_content_loop_after', 'business_aarambha_posts_navigation', 10 );

/**
 * Entry Header
 *
 * @see business_aarambha_get_post_thumbnail()
 * @see business_aarambha_blog_post_content()
 */
add_action( 'business_aarambha_posts_content', 'business_aarambha_get_post_thumbnail', 10 );
add_action( 'business_aarambha_posts_content', 'business_aarambha_blog_post_content', 10 );

/* ------------------------------ SEARCH PAGE ------------------------------ */

/**
 * Entry Header
 *
 * @see business_aarambha_search_posts_header()
 */
add_action( 'business_aarambha_search_posts_entry_header', 'business_aarambha_search_posts_header', 10 );

/**
 * Entry Content
 *
 * @see business_aarambha_search_posts_content()
 */
add_action( 'business_aarambha_search_posts_entry_content', 'business_aarambha_search_posts_content', 10 );

/**
 * Entry Footer
 *
 * @see business_aarambha_search_posts_footer()
 */
add_action( 'business_aarambha_search_posts_entry_footer', 'business_aarambha_search_posts_footer', 10 );

/* ------------------------------ SINGLE POST ------------------------------ */
/**
 * Single Post Content
 *
 * @see business_aarambha_get_post_thumbnail()
 * @see business_aarambha_single_post_content_elements()
 */
add_action( 'business_aarambha_post_content', 'business_aarambha_get_post_thumbnail', 10 );
add_action( 'business_aarambha_post_content', 'business_aarambha_single_post_content_elements', 15 );

/**
 * Single Post Content After
 *
 * @see business_aarambha_single_post_content_after_elements()
 */
add_action( 'business_aarambha_post_content_after', 'business_aarambha_single_post_content_after_elements', 10 );

/* ------------------------------ SINGLE PAGE ------------------------------ */

/**
 * Single Page Content
 *
 * @see business_aarambha_get_post_thumbnail()
 * @see business_aarambha_single_page_content_elements()
 */
add_action( 'business_aarambha_page_content', 'business_aarambha_get_post_thumbnail', 10 );
add_action( 'business_aarambha_page_content', 'business_aarambha_single_page_content_elements', 15 );

/**
 * Single Page Content After
 *
 * @see business_aarambha_single_page_content_after_elements()
 */
add_action( 'business_aarambha_page_content_after', 'business_aarambha_single_page_content_after_elements', 10 );

/* ------------------------------ COMMENTS ------------------------------ */
/**
 * Comments
 *
 * @see business_aarambha_comment_list()
 * @see business_aarambha_comment_form()
 */
add_action( 'business_aarambha_comments', 'business_aarambha_comment_list', 10 );
add_action( 'business_aarambha_comments', 'business_aarambha_comment_form', 15 );

/* ------------------------------ FOOTER ------------------------------ */
/**
 * Footer back to top
 *
 * @see business_aarambha_footer_back_to_top()
 */
add_action( 'business_aarambha_footer_after', 'business_aarambha_footer_back_to_top', 10 );
