<?php
/**
 * Business Aarambha functions to be hooked
 *
 * @package Business_Aarambha
 */


/* ------------------------------ HEADER ------------------------------ */

if ( ! function_exists( 'business_aarambha_head_meta' ) ) :
    /**
     * Meta head
     */
    function business_aarambha_head_meta() {
        ?>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="https://gmpg.org/xfn/11">
        <?php
    }
endif;

if ( ! function_exists( 'business_aarambha_header_banner' ) ) :
    /**
     * Header Banner
     */
    function business_aarambha_header_banner() {

        if ( is_front_page() && is_home() || is_front_page() ) {
            get_template_part( 'template-parts/banner/content', 'banner' );
        }
    }
endif;

if ( ! function_exists( 'business_aarambha_header_page_top_content' ) ) :
    /**
     * Featured page content page header
     */
    function business_aarambha_header_page_top_content() {

        if ( is_front_page() && is_home() ) {
            return;
        }

        // Check meta first to override and return (prevents filters from overriding meta)
        $page_header_enable = get_post_meta( Business_Aarambha_Helper::get_post_id(), 'business_aarambha_page_header_enable', true );
        if ( $page_header_enable && $page_header_enable != 'default' ) {
            return;
        }

        // Blog
        $elements = get_theme_mod(
            'business_aarambha_blog_page_header_elements',
            ['post-title']
        );
        $bottom_elements = get_theme_mod(
            'business_aarambha_blog_page_header_bottom_elements',
            ['breadcrumb']
        );
        if ( is_single() ) {
        	$elements = get_theme_mod(
                'business_aarambha_single_post_header_elements',
                ['post-title']
            );
        	$bottom_elements = get_theme_mod(
                'business_aarambha_single_post_header_bottom_elements',
                ['breadcrumb']
            );
        }

        // Is Single Page
        elseif ( is_page() ) {
            $elements = get_theme_mod(
                'business_aarambha_single_page_header_elements',
                ['post-title']
            );
            $bottom_elements = get_theme_mod(
                'business_aarambha_single_page_header_bottom_elements',
                ['breadcrumb']
            );
        }
        // Is 404 Page
        elseif ( is_404() ) {
            $elements = get_theme_mod(
                'business_aarambha_404_page_header_elements',
                ['post-title']
            );
            $bottom_elements = get_theme_mod(
                'business_aarambha_404_page_header_bottom_elements',
                ['breadcrumb']
            );
        }
        if ( ! empty( $elements ) || !empty( $bottom_elements ) ) : ?>

            <div class="page-title-wrap">

                <?php if ( !empty($elements) ) : ?>
                    <div class="container d-flex flex-column align-items-center text-center page-top-main-content">
                        <?php
                        foreach ( $elements as $element ) :

                            switch ( $element ) :

                                case 'post-title' :
                                    Business_Aarambha_Helper::page_header();
                                    break;

                                case 'breadcrumb' :
                                    Business_Aarambha_Breadcrumb::get_breadcrumb();
                                    break;

                                case 'excerpt' :
                                    echo '<div class="entry-content">';
                                    Business_Aarambha_Helper::post_excerpt();
                                    echo '</div><!-- .entry-content -->';
                                    break;

                                case 'post-meta' :
                                    echo '<div class="post-meta-wrapper header-post-meta">';
                                    Business_Aarambha_Helper::post_meta( get_the_ID() );
                                    echo '</div><!-- .header-post-meta -->';
                                    break;

                                case 'post-desc' :
                                    if ( ! is_404() ) {
                                        the_archive_description( '<div class="archive-description">', '</div>' );
                                    }
                                    break;

                            endswitch;

                        endforeach;
                        ?>
                    </div><!-- .page-top-main-content -->
                <?php endif; ?>

                <?php if ( !empty($bottom_elements) ) : ?>
                    <div class="page-top-overlay-content">
                        <div class="container d-flex">
                            <?php
                            foreach ( $bottom_elements as $bottom_element ) :

                                switch ( $bottom_element ) :

                                    case 'post-title' :
                                        Business_Aarambha_Helper::page_header();
                                        break;

                                    case 'breadcrumb' :
                                        Business_Aarambha_Breadcrumb::get_breadcrumb();
                                        break;

                                    case 'excerpt' :
                                        Business_Aarambha_Helper::post_excerpt();
                                        break;

                                    case 'post-meta' :

                                        echo '<div class="post-meta-wrapper header-post-meta">';
                                        Business_Aarambha_Helper::post_meta( get_the_ID() );
                                        echo '</div><!-- .header-post-meta -->';
                                        break;

                                endswitch;

                            endforeach;
                            ?>
                        </div><!-- .container -->
                    </div><!-- .page-top-overlay-content -->
                <?php endif; ?>

            </div>

        <?php endif;
    }
endif;

/* ------------------------------ BEFORE CONTENT ------------------------------ */

if ( ! function_exists( 'business_aarambha_site_content_start' ) ) :
    /**
     * Add custom wrapper div of site content wrapper
     */
    function business_aarambha_site_content_start() {
        ?>
        <div id="content" <?php Business_Aarambha_Helper::site_content_class(); ?>>
        <?php
    }
endif;

if ( ! function_exists( 'business_aarambha_page_section_start' ) ) :
    /**
     * Add custom wrapper for page section
     */
    function business_aarambha_page_section_start() {
        if ( is_404() ) {
            return;
        }
        $section_class = is_single() ? 'page-wrapper single-post-wrapper' : 'page-wrapper';
        ?>
        <section class="<?php echo esc_attr( $section_class ); ?>">
        <?php
    }
endif;

if ( ! function_exists( 'business_aarambha_page_container_start' ) ) :
    /**
     * Add custom wrapper for page container start
     */
    function business_aarambha_page_container_start() {
        if ( is_404() ) {
            return;
        }
        ?>
        <div class="container d-flex flex-wrap">
        <?php
    }
endif;

/* ------------------------------ AFTER CONTENT ------------------------------ */

if ( ! function_exists( 'business_aarambha_page_container_end' ) ) :
    /**
     * Close custom wrapper div after content
     */
    function business_aarambha_page_container_end() {
        if ( is_404() ) {
            return;
        }
        get_sidebar();
        echo '</div><! -- .container -->';
    }
endif;

if ( ! function_exists( 'business_aarambha_page_section_end' ) ) :
/**
 * Close custom wrapper div after content
 */
    function business_aarambha_page_section_end() {
        if ( is_404() ) {
            return;
        }
        echo '</section><! -- .page-wrapper -->';
    }
endif;

if ( ! function_exists( 'business_aarambha_site_content_end' ) ) :
    /**
     * Close custom wrapper div after content
     */
    function business_aarambha_site_content_end() {
        echo '</div><! -- #content -->';
    }
endif;

/* ------------------------------ BLOG PAGE CONTENT ------------------------------ */

if ( ! function_exists( 'business_aarambha_posts_navigation' ) ) :
    /**
     * Blog Posts navigation
     */
    function business_aarambha_posts_navigation() {

        Business_Aarambha_Helper::post_pagination();
    }
endif;

if ( ! function_exists( 'business_aarambha_blog_post_content' ) ) :
    /**
     * Blog post content
     */
    function business_aarambha_blog_post_content() {

        $posts_elements = get_theme_mod(
            'business_aarambha_blog_posts_elements',
            ['categories','post-title','post-meta','post-excerpt']
        );
        if ( ! empty( $posts_elements ) ) :

            echo '<div class="post-detail-wrap d-flex flex-column text-left">';

            foreach ( $posts_elements as $post_element ) :

                switch ( $post_element ) :

                    case 'post-title' :
                        Business_Aarambha_Helper::post_title();
                        break;

                    case 'post-excerpt' :
                        Business_Aarambha_Helper::post_content();
                        break;

                    case 'read-more' :
                        Business_Aarambha_Helper::read_more();
                        break;

                    case 'post-meta' :
                        Business_Aarambha_Helper::post_meta( get_the_ID() );
                        break;

                    case 'categories' :
                        Business_Aarambha_Helper::post_meta( get_the_ID(), ['categories'] );
                        break;

                endswitch;
            endforeach;

            echo '</div><!-- .post-details-wrap -->';

        endif;
    }
endif;

/* ------------------------------ POST CONTENT ------------------------------ */

if ( ! function_exists( 'business_aarambha_get_post_thumbnail' ) ) :
    /**
     * Post Thumbnail
     */
    function business_aarambha_get_post_thumbnail() {

        // Is Singular
        if ( is_singular() ) {

            $img_ratio = is_single() ? get_theme_mod('business_aarambha_single_post_featured_image_ratio',['desktop' => '16x9'] ) : get_theme_mod( 'business_aarambha_single_page_featured_image_ratio', ['desktop' => '16x9'] );

            $img_size = is_single() ? get_theme_mod('business_aarambha_single_post_featured_image_size',['desktop' => 'medium_large'] ) : get_theme_mod( 'business_aarambha_single_page_featured_image_size', ['desktop' => 'medium_large'] );

            $ratio = in_array( 'auto', $img_ratio ) ? '16x9' : $img_ratio['desktop'];

            business_aarambha_singular_post_thumbnail( $img_size['desktop'],$ratio );
        }
        else {
            $img_ratio = get_theme_mod( 'business_aarambha_blog_post_featured_image_ratio', ['desktop' => '16x9'] );

            $img_size = get_theme_mod( 'business_aarambha_blog_post_featured_image_size', ['desktop' => 'medium_large'] );

            $ratio = in_array( 'auto', $img_ratio ) ? '16x9' : $img_ratio['desktop'];

            business_aarambha_post_thumbnail( $img_size['desktop'],$ratio );
        }
    }
endif;

if ( ! function_exists( 'business_aarambha_single_post_content_elements' ) ) :
    /**
     * Single post content
     */
    function business_aarambha_single_post_content_elements() {

        $posts_elements = get_theme_mod(
            'business_aarambha_single_post_content_elements',
            ['categories','post-title','post-meta','post-content','tags']
        );
        if ( ! empty( $posts_elements ) ) :

            echo '<div class="post-detail-wrap d-flex flex-column text-left">';

            foreach ( $posts_elements as $post_element ) :

                switch ( $post_element ) :

                    case 'post-title' :
                        $html_tag = get_theme_mod( 'business_aarambha_single_post_title_tag', ['desktop' => 'h1'] );
                        the_title( '<' . esc_attr( $html_tag['desktop'] ) . ' class="entry-title">', '</' . esc_attr( $html_tag['desktop'] ) . '>' );
                        break;

                    case 'post-content' :
                        business_aarambha_single_post_entry_content();
                        break;

                    case 'post-meta' :
                        Business_Aarambha_Helper::post_meta( get_the_ID() );
                        break;

                    case 'categories' :
                        Business_Aarambha_Helper::post_meta( get_the_ID(), ['categories'] );
                        break;

                    case 'tags' :
                        Business_Aarambha_Helper::post_meta( get_the_ID(), ['tags'] );
                        break;

                endswitch;
            endforeach;

             business_aarambha_entry_footer();

            echo '</div><!-- .post-details-wrap -->';

        endif;
    }
endif;

if ( ! function_exists( 'business_aarambha_single_post_entry_content' ) ) :
    /**
     * Entry Post Content
     */
    function business_aarambha_single_post_entry_content() {
        ?>
        <div class="entry-content">

            <?php
            /**
             * Functions hooked in to business_aarambha_post_content_top action.
             *
             */
            do_action( 'business_aarambha_post_content_top' );
            ?>

            <?php
            the_content(
                sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'business-aarambha' ),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    wp_kses_post( get_the_title() )
                )
            );
            ?>

            <?php

            wp_link_pages(
                array(
                    'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'business-aarambha' ),
                    'after'  => '</div>',
                )
            );
            ?>

            <?php
            /**
             * Functions hooked in to business_aarambha_post_content_bottom action.
             *
             */
            do_action( 'business_aarambha_post_content_bottom' );
            ?>

        </div><!-- .entry-content -->

        <?php
    }
endif;

if ( ! function_exists( 'business_aarambha_single_post_content_after_elements' ) ) :
    /**
     * Post Footer for extra elements
     */
    function business_aarambha_single_post_content_after_elements() {

        /**
         * Functions hooked in to business_aarambha_single_post_content_after_top action.
         *
         */
        do_action( 'business_aarambha_single_post_content_after_top' );
        ?>
        <?php
        $elements = get_theme_mod(
            'business_aarambha_single_post_content_after_elements',
            ['post-comments','post-navigation']
        );

        if ( ! empty( $elements ) ) :

            foreach ( $elements as $element ) :

                switch ( $element ) :

                    case 'post-comments' :
                        Business_Aarambha_Helper::post_comment();
                        break;

                    case 'post-navigation' :
                        Business_Aarambha_Helper::post_navigation();
                        break;

                    case 'author-box' :
                        Business_Aarambha_Helper::author_box();
                        break;

                    case 'related-posts' :
                        Business_Aarambha_Helper::related_posts();
                        break;

                endswitch;

            endforeach;
        endif;

        ?>

        <?php
        /**
         * Functions hooked in to business_aarambha_single_post_content_after_bottom action.
         *
         */
        do_action( 'business_aarambha_single_post_content_after_bottom' );

    }
endif;

/* ------------------------------ PAGE CONTENT ------------------------------ */

if ( ! function_exists( 'business_aarambha_single_page_content_elements' ) ) :
    /**
     * Single page content
     */
    function business_aarambha_single_page_content_elements() {

        $posts_elements = get_theme_mod(
            'business_aarambha_single_page_content_elements',
            ['post-title','post-content']
        );
        if ( ! empty( $posts_elements ) ) :

            echo '<div class="post-detail-wrap d-flex flex-column text-left">';

            foreach ( $posts_elements as $post_element ) :

                switch ( $post_element ) :

                    case 'post-title' :
                        $html_tag = get_theme_mod( 'business_aarambha_single_page_title_tag', ['desktop' => 'h1'] );
                        the_title( '<' . esc_attr( $html_tag['desktop'] ) . ' class="entry-title">', '</' . esc_attr( $html_tag['desktop'] ) . '>' );
                        break;

                    case 'post-content' :
                        business_aarambha_single_page_entry_content();
                        break;

                endswitch;
            endforeach;

             business_aarambha_entry_footer();

            echo '</div><!-- .post-details-wrap -->';

        endif;
    }
endif;

if ( ! function_exists( 'business_aarambha_single_page_entry_content' ) ) :
    /**
     * Entry Page Content
     */
    function business_aarambha_single_page_entry_content() {
        ?>
        <div class="entry-content">

            <?php
            /**
             * Functions hooked in to business_aarambha_page_content_top action.
             *
             */
            do_action( 'business_aarambha_page_content_top' );
            ?>

            <?php
            the_content(
                sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'business-aarambha' ),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    wp_kses_post( get_the_title() )
                )
            );
            ?>

            <?php

            wp_link_pages(
                array(
                    'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'business-aarambha' ),
                    'after'  => '</div>',
                )
            );
            ?>

            <?php
            /**
             * Functions hooked in to business_aarambha_page_content_bottom action.
             *
             */
            do_action( 'business_aarambha_page_content_bottom' );
            ?>

        </div><!-- .entry-content -->

        <?php
    }
endif;

if ( ! function_exists( 'business_aarambha_single_page_content_after_elements' ) ) :
    /**
     * Page after content extra elements
     */
    function business_aarambha_single_page_content_after_elements() {

        /**
         * Functions hooked in to business_aarambha_single_page_content_after_top action.
         *
         */
        do_action( 'business_aarambha_single_page_content_after_top' );
        ?>
        <?php
        $elements = get_theme_mod(
            'business_aarambha_single_page_content_after_elements',
            ['post-comments']
        );

        if ( ! empty( $elements ) ) :

            foreach ( $elements as $element ) :

                switch ( $element ) :

                    case 'post-comments' :
                        Business_Aarambha_Helper::post_comment();
                        break;

                endswitch;

            endforeach;
        endif;

        ?>

        <?php
       /**
         * Functions hooked in to business_aarambha_single_page_content_after_bottom action.
         *
         */
        do_action( 'business_aarambha_single_page_content_after_bottom' );

    }
endif;

/* ------------------------------ COMMENTS ------------------------------ */

if ( ! function_exists( 'business_aarambha_comment_list' ) ) :
    /**
     * comment list
     */
    function business_aarambha_comment_list() {

        if ( have_comments() ) {

            /**
             * Functions hooked into business_aarambha_comments_list_before action
             *
             */
            do_action( 'business_aarambha_comments_list_before' );

            $title_output = '<h2 class="comments-title">';
            $comment_count = (int) get_comments_number();
            if ( 1 === $comment_count ) {
                $title_output .= esc_html__( 'One Comment', 'business-aarambha' );
            } else {
                $title_output .= sprintf(
                /* translators: 1: comment count number */
                esc_html( _nx( '%1$s Comment', '%1$s Comments', $comment_count, 'comments title', 'business-aarambha' ) ),
                // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                number_format_i18n( $comment_count )
                );
            }
            $title_output .= '</h2><!-- .comments-title -->';
            echo wp_kses_post( apply_filters( 'business_aarambha_post_comments_title', $title_output ) );

            the_comments_navigation();
            echo '<ol class="comment-list">';
            wp_list_comments(
				array(
                    'style'       => 'ol',
                    'short_ping'  => true,
                    'avatar_size' => 60,
				)
			);
            echo '<ol><!-- .comment-list -->';
            the_comments_navigation();

            /**
             * Functions hooked into business_aarambha_comments_list_after action
             *
             */
            do_action( 'business_aarambha_comments_list_after' );
        }
    }
endif;

if ( ! function_exists( 'business_aarambha_comment_form' ) ) :
    /**
     * comment form
     */
    function business_aarambha_comment_form() {
        // You can start editing here -- including this comment!
        if ( have_comments() ) :

            // If comments are closed and there are comments, let's leave a little note, shall we?
            if ( ! comments_open() ) :
                ?>
                <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'business-aarambha' ); ?></p>
                <?php
            endif;

        endif; // Check for have_comments().

        comment_form();
    }
endif;

/* ------------------------------ FOOTER ------------------------------ */

if ( ! function_exists( 'business_aarambha_footer_back_to_top' ) ) :
    /**
     * Footer Back to Top
     */
    function business_aarambha_footer_back_to_top() {
        $back_to_top = get_theme_mod(
                'business_aarambha_footer_back_to_top_enable',
                ['desktop'=>'true']
        );
        if ( $back_to_top && array_key_exists( 'desktop', $back_to_top ) ) :
        ?>
        <div class="back-to-top">
            <button href="#masthead" title="<?php esc_attr_e('Go to Top','business-aarambha'); ?>"><i class="fa fa-angle-up" aria-hidden="true"></i></button>
        </div><!-- .back-to-top -->
        <?php
        endif;
    }
endif;

/* ------------------------------ CONTENT ------------------------------ */

if ( ! function_exists( 'business_aarambha_menu_fallback' ) ) :

	/**
	 * Menu fallback for primary menu.
	 *
	 * Contains wp_list_pages to display pages created,
	 */
	function business_aarambha_menu_fallback() {
		$output  = '';
		$output .= '<div class="menu-top-menu-container">';
		$output .= '<ul id="primary-menu-list" class="menu-wrapper d-flex flex-wrap">';

		$output .= wp_list_pages(
			array(
				'echo'     => false,
				'title_li' => false,
			)
		);

		$output .= '</ul>';
		$output .= '</div>';

		// @codingStandardsIgnoreStart
		echo $output;
		// @codingStandardsIgnoreEnd
	}

endif;

if ( ! function_exists( 'business_aarambha_mobile_menu_fallback' ) ) :

    /**
     * Menu fallback for mobile menu.
     *
     * Contains wp_list_pages to display pages created,
     */
    function business_aarambha_mobile_menu_fallback() {
        $output  = '';
        $output .= '<div class="menu-top-menu-container">';
        $output .= '<ul id="mobile-menu-list" class="menu-wrapper d-flex flex-wrap d-none">';

        $output .= wp_list_pages(
            array(
                'echo'     => false,
                'title_li' => false,
            )
        );

        $output .= '</ul>';
        $output .= '</div>';

        // @codingStandardsIgnoreStart
        echo $output;
        // @codingStandardsIgnoreEnd
    }

endif;
