<?php
/**
 * Business Aarambha Theme Customizer Selective Refresh
 *
 * @package Business_Aarambha
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( isset( $wp_customize->selective_refresh ) ) {

    $wp_customize->selective_refresh->add_partial(
        'blogname',
        array(
            'selector'        => '.site-title a',
            'render_callback' => [ $this, 'business_aarambha_customize_partial_blogname' ],
        )
    );
    $wp_customize->selective_refresh->add_partial(
        'blogdescription',
        array(
            'selector'        => '.site-description',
            'render_callback' => [ $this, 'business_aarambha_customize_partial_blogdescription' ],
        )
    );

    // Header Builder
    $wp_customize->selective_refresh->add_partial(
        'business_aarambha_header',
        array(
            'selector'          => '.site-header',
            'settings'          => array(
                'business_aarambha_header_builder_controller_section'
            ),
            'render_callback'   => function() {
                Business_Aarambha_Customizer_Header_Builder()->business_aarambha_header_display();
            }
        )
    );

    // Footer Builder
    $wp_customize->selective_refresh->add_partial(
        'business_aarambha_footer',
        array(
            'selector'          => '.site-footer',
            'settings'          => array(
                'business_aarambha_footer_builder_controller_section'
            ),
            'render_callback'   => function() {
                Business_Aarambha_Customizer_Footer_Builder()->business_aarambha_footer_display();
            }
        )
    );
}
