<?php
/**
 * Business Aarambha Theme Customizer Single Post Title settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Single_Post_Title_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Title Tag
            'business_aarambha_single_post_title_tag' => [
                'type'              => 'buttonset',
                'default'           => ['desktop' => 'h1'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
                'label'             => esc_html__( 'Heading Tag', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_post_title_section',
                'priority'          => 15,
                'choices' 			=> array(
                    'h1'                => esc_html__( 'H1', 'business-aarambha' ),
                    'h2'                => esc_html__( 'H2', 'business-aarambha' ),
                    'h3'                => esc_html__( 'H3', 'business-aarambha' ),
                    'h4'                => esc_html__( 'H4', 'business-aarambha' ),
                    'h5'                => esc_html__( 'H5', 'business-aarambha' ),
                    'h6'                => esc_html__( 'H6', 'business-aarambha' )
                )
            ]
        ];
    }

}
new Business_Aarambha_Customize_Single_Post_Title_Fields();
