<?php
/**
 * Business Aarambha Theme Customizer Single Post Element settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Single_Post_Content_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Content Elements
            'business_aarambha_single_post_content_elements' => [
                'type'              => 'sortable',
                'default'           => ['categories','post-title','post-meta','post-content','tags'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Content Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable lists for single post content elements and rearrange the order by drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_post_content_section',
                'priority'          => 10,
                'choices'           => [
                    'post-title'        => esc_html__( 'Post Title', 'business-aarambha' ),
                    'post-meta'         => esc_html__( 'Post Meta', 'business-aarambha' ),
                    'categories'        => esc_html__( 'Categories', 'business-aarambha' ),
                    'post-content'      => esc_html__( 'Post Content', 'business-aarambha' ),
                    'tags'              => esc_html__( 'Tags', 'business-aarambha' ),
                ]
            ],
            // Content After Elements
            'business_aarambha_single_post_content_after_elements' => [
                'type'              => 'sortable',
                'default'           => ['post-comments','post-navigation'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Content After Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'To display lists Elements after post content, enable them. And sort them by drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_post_content_section',
                'priority'          => 25,
                'choices'           => [
                    'post-comments'     => esc_html__( 'Comments', 'business-aarambha' ),
                    'post-navigation'   => esc_html__( 'Post Navigation', 'business-aarambha' ),
                    'author-box'        => esc_html__( 'Author Box', 'business-aarambha' ),
                    'related-posts'     => esc_html__( 'Related Posts', 'business-aarambha' )
                ]
            ],
        ];
    }

}
new Business_Aarambha_Customize_Single_Post_Content_Fields();
