<?php
/**
 * Business Aarambha Theme Customizer Single Page Sidebar settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Single_Page_Sidebar_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Sidebar
            'business_aarambha_single_page_sidebar_layout' => [
                'type'              => 'radio_image',
                'default'           => 'right',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_choices' ],
                'label'             => esc_html__( 'Sidebar', 'business-aarambha' ),
                'description'       => esc_html__( 'Select sidebar layout for single page.', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_page_sidebar_section',
                'priority'          => 15,
                'choices' 			=> array(
                    'left'              => BUSINESS_AARAMBHA_URI . 'assets/images/left.svg',
                    'right'  		    => BUSINESS_AARAMBHA_URI . 'assets/images/right.svg',
                    'none'  		    => BUSINESS_AARAMBHA_URI . 'assets/images/none.svg',
                ),
                'l10n'              => [
                    'left'              => esc_html__( 'Left', 'business-aarambha' ),
                    'right'             => esc_html__( 'Right', 'business-aarambha' ),
                    'none'              => esc_html__( 'None', 'business-aarambha' )
                ]
            ],
        ];
    }

}
new Business_Aarambha_Customize_Single_Page_Sidebar_Fields();
