<?php
/**
 * Business Aarambha Theme Customizer Single Page Header settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Single_Page_Header_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Page Header
            'business_aarambha_single_page_header_elements' => [
                'type'              => 'sortable',
                'default'           => ['post-title'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Main Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable lists of page header main elements and rearrange the vertical order by drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_page_header_section',
                'priority'          => 15,
                'choices'           => [
                    'post-title'        => esc_html__( 'Page Title', 'business-aarambha' ),
                    'excerpt'           => esc_html__( 'Excerpt', 'business-aarambha' ),
                    'breadcrumb'        => esc_html__( 'Breadcrumb', 'business-aarambha' )
                ],
            ],
            // Bottom Overlay Elements
            'business_aarambha_single_page_header_bottom_elements' => [
                'type'              => 'sortable',
                'default'           => ['breadcrumb'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Bottom Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable/Disable breadcrumb from page header bottom content.', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_page_header_section',
                'priority'          => 20,
                'choices'           => [
                    'breadcrumb'        => esc_html__( 'Breadcrumb', 'business-aarambha' )
                ],
            ]
        ];
    }

}
new Business_Aarambha_Customize_Single_Page_Header_Fields();
