<?php
/**
 * Business Aarambha Theme Customizer Single Page Element settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Single_Page_Content_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Content Elements
            'business_aarambha_single_page_content_elements' => [
                'type'              => 'sortable',
                'default'           => ['post-title','post-content'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Content Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable lists for single post content elements and rearrange the order by drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_page_content_section',
                'priority'          => 10,
                'choices'           => [
                    'post-title'        => esc_html__( 'Post Title', 'business-aarambha' ),
                    'post-content'      => esc_html__( 'Post Content', 'business-aarambha' )
                ]
            ],
            // Content After Elements
            'business_aarambha_single_page_content_after_elements' => [
                'type'              => 'sortable',
                'default'           => ['post-comments'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Content After Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable/Disable comment from page content area.', 'business-aarambha' ),
                'section'           => 'business_aarambha_single_page_content_section',
                'priority'          => 25,
                'choices'           => [
                    'post-comments'     => esc_html__( 'Comments', 'business-aarambha' )
                ]
            ],
        ];
    }

}
new Business_Aarambha_Customize_Single_Page_Content_Fields();
