<?php
/**
 * Business Aarambha Theme Customizer Typography settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Typography_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Base Typography
            'business_aarambha_base_typography' => [
                'type'              => 'typography',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_typography' ],
                'label'             => esc_html__( 'Base', 'business-aarambha' ),
                'description'       => esc_html__( 'Set Typography for the base of your website.', 'business-aarambha' ),
                'section'           => 'business_aarambha_typography_section',
                'priority'          => 10,
                'fields'            => ['font_family'=>true,'font_variant'=>true]
            ]
        ];

    }

}
new Business_Aarambha_Customize_Global_Typography_Fields();
