<?php
/**
 * Business Aarambha Theme Customizer Site Content Settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Site_Content_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {


        $this->args = [
            // Max Width
            'business_aarambha_site_max_width' => [
                'type'              => 'range',
                'default'           => ['desktop' => '1170px'],
                'section'           => 'business_aarambha_site_content_section',
                'priority'          => 15,
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_range' ],
                'label'             => esc_html__( 'Max Width', 'business-aarambha' ),
                'description'       => esc_html__( 'Set Max width for container. Default value is 1170px.', 'business-aarambha' ),
                'input_attrs'       => [
                    'min'               => 0,
                    'max'               => 2000
                ]
            ]
        ];
    }

}
new Business_Aarambha_Customize_Global_Site_Content_Fields();
