<?php
/**
 * Business Aarambha Theme Customizer Sidebar settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Sidebar_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Sticky Sidebar
            'business_aarambha_sidebar_sticky' => [
                'type'              => 'toggle',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Sticky Sidebar', 'business-aarambha' ),
                'description'       => esc_html__( 'Toggle to enable sticky sidebar. See the effect on content scrolling.', 'business-aarambha' ),
                'section'           => 'business_aarambha_sidebar_section',
                'priority'          => 15,
            ]
        ];
    }

}
new Business_Aarambha_Customize_Global_Sidebar_Fields();
