<?php
/**
 * Business Aarambha Theme Customizer Post Meta settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Post_Meta_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Meta Elements
            'business_aarambha_post_meta_elements' => [
                'type'              => 'sortable',
                'default'           => ['author','date','comment'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Post Meta Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable Post Meta elements and rearrange lists using drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_post_meta_section',
                'priority'          => 10,
                'choices'           => [
                    'author'            => esc_html__( 'Author', 'business-aarambha' ),
                    'categories'        => esc_html__( 'Categories', 'business-aarambha' ),
                    'tags'              => esc_html__( 'Tags', 'business-aarambha' ),
                    'date'              => esc_html__( 'Publish Date', 'business-aarambha' ),
                    'comment'           => esc_html__( 'Comments', 'business-aarambha' )
                ],
            ]
        ];

    }

}
new Business_Aarambha_Customize_Global_Post_Meta_Fields();
