<?php
/**
 * Business Aarambha Theme Customizer Placeholder settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Placeholder_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Color
            'business_aarambha_placeholder_color' => [
                'type'              => 'color',
                'default'           => [
                    'color_1'           => '#dbdcdf'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Placeholder Color', 'business-aarambha' ),
                'description'       => esc_html__( 'Set color in placeholder if there isn’t a featured image.', 'business-aarambha' ),
                'section'           => 'business_aarambha_placeholder_section',
                'priority'          => 10,
            ],
            // Image
            'business_aarambha_placeholder_image' => [
                'type'              => 'image',
                'default'           => '',
                'sanitize_callback' => 'esc_url_raw',
                'label'             => esc_html__( 'Placeholder Image', 'business-aarambha' ),
                'description'       => esc_html__( 'Set placeholder image for no featured image. It will replace the placeholder color.', 'business-aarambha' ),
                'section'           => 'business_aarambha_placeholder_section',
                'priority'          => 15,
            ]
        ];
    }

}
new Business_Aarambha_Customize_Global_Placeholder_Fields();
