<?php
/**
 * Business Aarambha Theme Customizer Page Header settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Page_Header_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
			// Background Image
			'business_aarambha_page_header_background' => [
				'type'              => 'background',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_background' ],
				'label'             => esc_html__( 'Background Image', 'business-aarambha' ),
				'description'       => esc_html__( 'To set the background image for the page header container.', 'business-aarambha' ),
				'section'           => 'business_aarambha_page_header_section',
				'priority'          => 5,
				'fields'            => ['image' => true, 'position' => true, 'attachment' => true, 'repeat' => true, 'size' => true ],
			],
			// Background Overlay
			'business_aarambha_page_header_background_overlay' => [
				'type'              => 'background',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_background' ],
				'label'             => esc_html__( 'Background Overlay', 'business-aarambha' ),
				'description'       => esc_html__( 'Set Background overlay color on page header container.', 'business-aarambha' ),
				'section'           => 'business_aarambha_page_header_section',
				'priority'          => 5,
				'inherits'          => [
					'color_1'           => 'var(--color-bg-2)'
				],
				'fields'            => ['colors' => true],
			]
        ];

    }

}
new Business_Aarambha_Customize_Global_Page_Header_Fields();
