<?php
/**
 * Business Aarambha Theme Customizer Color settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Color_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Accent Color
            'business_aarambha_accent_color' => [
                'type'              => 'color',
                'default'           => [
                    'color_1'           => '#E4BD86',
                    'color_2'           => '#0F1F31'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Accent', 'business-aarambha' ),
                'section'           => 'colors',
                'priority'          => 10,
                'colors'            => [
                    'color_1'           => esc_html__( 'Primary', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Secondary', 'business-aarambha' )
                ],
                'inherits'            => [
                    'color_1'           => 'var(--color-accent)',
                    'color_2'           => 'var(--color-accent-secondary)'
                ]
            ],
            // H1-H6 Color
            'business_aarambha_heading_color' => [
                'type'              => 'color',
                'default'           => [
                    'color_1'           => '#3d4151'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'H1 -H6', 'business-aarambha' ),
                'section'           => 'colors',
                'priority'          => 15,
                'inherits'            => [
                    'color_1'           => 'var(--color-heading)'
                ]
            ],
            // Text Color
            'business_aarambha_text_color' => [
                'type'              => 'color',
                'default'           => [
                    'color_1'           => '#727272'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Base Text', 'business-aarambha' ),
                'section'           => 'colors',
                'priority'          => 20,
                'colors'            => [
                    'color_1'           => esc_html__( 'Color 1', 'business-aarambha' )
                ],
                'inherits'            => [
                    'color_1'           => 'var(--color-1)'
                ]
            ],
            // Link Color
            'business_aarambha_link_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Link', 'business-aarambha' ),
                'section'           => 'colors',
                'priority'          => 25,
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                    'color_3'           => esc_html__( 'Visited', 'business-aarambha' )
                ],
                'inherits'            => [
                    'color_1'           => 'var(--color-accent-secondary)',
                    'color_2'           => 'var(--color-accent)',
                    'color_3'           => 'var(--color-1)'
                ]
            ]
        ];
    }

}
new Business_Aarambha_Customize_Global_Color_Fields();
