<?php
/**
 * Business Aarambha Theme Customizer Body settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Global_Body_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        // Background
        $this->args = [
            'business_aarambha_body_background' => [
                'type'              => 'background',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_background' ],
                'label'             => esc_html__( 'Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Color or Image as the background of your site.', 'business-aarambha' ),
                'section'           => 'business_aarambha_body_section',
                'priority'          => 10,
                'inherits'          => [
                    'color_1'           => 'var(--color-bg-1)',
                ],
				'fields'            => ['background' => true, 'colors' => true,'image' => true, 'position' => true, 'attachment' => true, 'repeat' => true, 'size' => true],
            ]
        ];
    }

}
new Business_Aarambha_Customize_Global_Body_Fields();
