<?php
/**
 * Business Aarambha Theme Customizer Blog Posts Layout settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Blog_Posts_Content_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Posts Elements
            'business_aarambha_blog_posts_elements' => [
                'type'              => 'sortable',
                'default'           => ['categories','post-title','post-meta','post-excerpt'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Content Elements', 'business-aarambha' ),
				'description'       => esc_html__( 'Enable lists for blog post content elements and rearrange the order by drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_blog_posts_layout_section',
                'priority'          => 10,
                'choices'           => [
                    'post-title'        => esc_html__( 'Post Title', 'business-aarambha' ),
                    'post-meta'         => esc_html__( 'Post Meta', 'business-aarambha' ),
                    'categories'        => esc_html__( 'Categories', 'business-aarambha' ),
                    'post-excerpt'      => esc_html__( 'Post Excerpt', 'business-aarambha' ),
                    'read-more'         => esc_html__( 'Read More', 'business-aarambha' )
                ],
            ],
        ];
    }

}
new Business_Aarambha_Customize_Blog_Posts_Content_Fields();
