<?php
/**
 * Business Aarambha Theme Customizer Blog Post Read More settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Blog_Post_Read_More_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Type
            'business_aarambha_blog_post_read_btn_type' => [
                'type'              => 'buttonset',
                'default'           => ['desktop'=>'button'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
                'label'             => esc_html__( 'Display as', 'business-aarambha' ),
                'section'           => 'business_aarambha_blog_post_read_more_section',
                'priority'          => 20,
                'choices'           => [
                    'text'              => esc_html__( 'Text', 'business-aarambha' ),
                    'button'            => esc_html__( 'Button', 'business-aarambha' )
                ]
            ],
            // Button Arrow
            'business_aarambha_blog_post_read_more_btn_arrow' => [
                'type'              => 'toggle',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Button Arrow', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable Arrow Icon after Button/Text.', 'business-aarambha' ),
                'section'           => 'business_aarambha_blog_post_read_more_section',
                'priority'          => 25,
            ]
        ];
    }

}
new Business_Aarambha_Customize_Blog_Post_Read_More_Fields();
