<?php
/**
 * Business Aarambha Theme Customizer Blog Post Featured Image settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Blog_Post_Featured_Image_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Image Ratio
            'business_aarambha_blog_post_featured_image_ratio' => [
                'type'              => 'buttonset',
                'default'           => ['desktop' => '16x9'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
                'label'             => esc_html__( 'Aspect Ratio', 'business-aarambha' ),
                'description'       => esc_html__( 'Set custom aspect ratio for featured image. Choose proper aspects for better appearance.', 'business-aarambha' ),
                'section'           => 'business_aarambha_blog_post_featured_image_section',
                'priority'          => 15,
                'choices' 			=> array(
                    'auto'              => esc_html__( 'Auto', 'business-aarambha' ),
                    '1x1'               => esc_html__( '1:1', 'business-aarambha' ),
                    '4x3'               => esc_html__( '4:3', 'business-aarambha' ),
                    '16x9'              => esc_html__( '16:9', 'business-aarambha' ),
                    '3x4'               => esc_html__( '3:4', 'business-aarambha' ),
                )
            ],
            // Image Size
            'business_aarambha_blog_post_featured_image_size' => [
                'type'              => 'buttonset',
                'default'           => ['desktop' => 'medium_large'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
                'label'             => esc_html__( 'Image Size', 'business-aarambha' ),
                'description'       => esc_html__( 'Set proper size for featured image. Selecting a bigger image size may display a better appearance but takes more time on loading websites.', 'business-aarambha' ),
                'section'           => 'business_aarambha_blog_post_featured_image_section',
                'priority'          => 20,
                'choices' 			=> [
                    'thumbnail'         => esc_html__( 'Small', 'business-aarambha' ),
                    'medium'            => esc_html__( 'Medium', 'business-aarambha' ),
                    'medium_large'      => esc_html__( 'Medium Large', 'business-aarambha' ),
                    'large'             => esc_html__( 'Large', 'business-aarambha' ),
                ]
            ]
        ];
    }

}
new Business_Aarambha_Customize_Blog_Post_Featured_Image_Fields();
