<?php
/**
 * Business Aarambha Theme Customizer Blog Pagination settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Blog_Pagination_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Pagination Type
            'business_aarambha_blog_pagination_type' => [
                'type'              => 'select',
                'default'           => 'nxt-prv',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_choices' ],
                'label'             => esc_html__( 'Pagination Type', 'business-aarambha' ),
                'section'           => 'business_aarambha_blog_pagination_section',
                'priority'          => 15,
                'choices'           => [
                    'nxt-prv'           => esc_html__( 'Next/Prev', 'business-aarambha' ),
                    'numeric'           => esc_html__( 'Numeric', 'business-aarambha' )
                ]
            ]
        ];
    }

}
new Business_Aarambha_Customize_Blog_Pagination_Fields();
