<?php
/**
 * Business Aarambha Theme Customizer Header Banner Post Content settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Banner_Post_Content_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Posts Elements
            'business_aarambha_banner_post_content_elements' => [
                'type'              => 'sortable',
                'default'           => ['post-title','post-excerpt','read-more'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Content Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable lists for blog post content elements and rearrange the order by drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_banner_post_content_section',
                'priority'          => 10,
                'choices'           => [
                    'post-title'        => esc_html__( 'Post Title', 'business-aarambha' ),
                    'post-excerpt'      => esc_html__( 'Post Excerpt', 'business-aarambha' ),
                    'read-more'         => esc_html__( 'Read More', 'business-aarambha' )
                ],
            ],
        ];
    }

}
new Business_Aarambha_Customize_Banner_Post_Content_Fields();
