<?php
/**
 * Business Aarambha Theme Customizer Header Banner settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Banner_General_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Banner Type
            'business_aarambha_header_banner_type' => [
                'type'              => 'buttonset',
                'default'           => ['desktop' => 'banner'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
                'label'             => esc_html__( 'Banner Type', 'business-aarambha' ),
                'description'       => esc_html__( 'Set header banner type as normal banner or banner as slider or none.', 'business-aarambha' ),
                'section'           => 'business_aarambha_banner_general_section',
                'priority'          => 5,
                'choices' 			=> [
                    'banner'            => esc_html__( 'Banner', 'business-aarambha' ),
                    'slider'            => esc_html__( 'Slider', 'business-aarambha' ),
                    'none'              => esc_html__( 'None', 'business-aarambha' ),
                ]
            ],
            // Select Post Id
            'business_aarambha_header_banner_post_id' => [
                'type'              => 'select',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_choices' ],
                'label'             => esc_html__( 'Select Post', 'business-aarambha' ),
                'description'       => esc_html__( 'Set post query to load with specific post.', 'business-aarambha' ),
                'section'           => 'business_aarambha_banner_general_section',
                'priority'          => 10,
                'choices'  			=> Business_Aarambha_Helper::get_posts(
                    array(
                        'posts_per_page' => -1,
                        'post_type'      => 'post'
                    )
                )
            ],
            // Post By Category
            'business_aarambha_header_banner_slider_cat' => [
                'type'              => 'select',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_choices' ],
                'label'             => esc_html__( 'Posts by Category', 'business-aarambha' ),
                'description'       => esc_html__( 'Set post query to load with specific category. It will load the latest post by default.', 'business-aarambha' ),
                'section'           => 'business_aarambha_banner_general_section',
                'priority'          => 15,
                'choices'           => Business_Aarambha_Helper::get_terms('category' ),
            ],
            // Number of Slides
            'business_aarambha_header_banner_slider_limit' => [
                'type'              => 'range',
                'default'           => ['desktop' => 3 ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_range' ],
                'label'             => esc_html__( 'Slides Limit', 'business-aarambha' ),
                'description'       => esc_html__( 'Set banner slide limit. Upgrade pro theme to unlock unlimited slide.', 'business-aarambha' ),
                'section'           => 'business_aarambha_banner_general_section',
                'priority'          => 20,
                'units'             => [],
                'input_attrs'       => [
                    'min'               => 1,
                    'step'              => 1,
                    'max'               => 5
                ]
            ],
            // Sticky Sidebar
            'business_aarambha_header_banner_slider_pagination' => [
                'type'              => 'toggle',
                'default'           => ['desktop'=> 'true'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Slider Pagination', 'business-aarambha' ),
                'description'       => esc_html__( 'Toggle to enable/disable slider pagination.', 'business-aarambha' ),
                'section'           => 'business_aarambha_banner_general_section',
                'priority'          => 25,
            ]
        ];
    }

}
new Business_Aarambha_Customize_Banner_General_Fields();
