<?php
/**
 * Business Aarambha Theme Customizer 404 Page Content settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_404_Page_Content_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
			// Grouping Settings
			'business_aarambha_404_error_grouping_settings' => [
				'type'              => 'group',
				'section'           => 'business_aarambha_404_page_content_section',
				'priority'          => 10,
				'choices'           => [
					'normal'            => array(
						'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
						'controls'      => array(
							'business_aarambha_404_error_page_content_elements',
							'business_aarambha_404_error_image'
						)
					),
					'hover'         => array(
						'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
						'controls'      => array(
							'business_aarambha_404_error_background',
						)
					)
				]
			],
            // Error Page Content
            'business_aarambha_404_error_page_content_elements' => [
                'type'              => 'sortable',
                'default'           => ['title','subtitle','button'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_sortable' ],
                'label'             => esc_html__( 'Sort Elements', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable page content elements and order their list with drag and drop.', 'business-aarambha' ),
                'section'           => 'business_aarambha_404_page_content_section',
                'priority'          => 15,
                'choices'           => [
                    'image'             => esc_html__( 'Image', 'business-aarambha' ),
                    'title'             => esc_html__( 'Title', 'business-aarambha' ),
                    'subtitle'          => esc_html__( 'Sub Title', 'business-aarambha' ),
                    'button'            => esc_html__( 'Button', 'business-aarambha' ),
                    'search'            => esc_html__( 'Search', 'business-aarambha' )
                ],
            ],
            // Image
            'business_aarambha_404_error_image' => [
                'type'              => 'image',
                'default'           => '',
                'sanitize_callback' => 'esc_url_raw',
                'label'             => esc_html__( 'Image', 'business-aarambha' ),
                'section'           => 'business_aarambha_404_page_content_section',
                'priority'          => 20,
            ],
			// Background Image
			'business_aarambha_404_error_background' => [
				'type'              => 'background',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_background' ],
				'label'             => esc_html__( 'Background Image', 'business-aarambha' ),
				'description'       => esc_html__( 'Set background image for 404 page content.', 'business-aarambha' ),
				'section'           => 'business_aarambha_404_page_content_section',
				'priority'          => 75,
				'fields'            => ['image' => true, 'position' => true, 'attachment' => true, 'repeat' => true, 'size' => true ],
			],
        ];
    }

}
new Business_Aarambha_Customize_404_Page_Content_Fields();
