<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * WooCommerce Header Cart Header Customizer Options
 * @package Business_Aarambha
 */

if ( ! class_exists( 'Business_Aarambha_WooCommerce_Cart_Header' ) ) :

    class Business_Aarambha_WooCommerce_Cart_Header {

        /**
         * Panel ID
         *
         * @var string
         * @access public
         * @since 1.0.0
         *
         */
        public $element = 'wc_cart';

        /**
         * Main Instance
         *
         * Insures that only one instance of Business_Aarambha_WooCommerce_Cart_Header exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since    1.0.0
         * @access   public
         *
         * @return object
         */
        public static function instance() {

            // Store the instance locally to avoid private static replication
            static $instance = null;

            // Only run these methods if they haven't been ran previously
            if ( null === $instance ) {
                $instance = new Business_Aarambha_WooCommerce_Cart_Header;
            }

            // Always return the instance
            return $instance;
        }

        /**
         *  Run functionality with hooks
         *
         * @since    1.0.0
         * @access   public
         *
         * @return void
         */
        public function run() {

            add_filter( 'Business_Aarambha_Customizer_Header_Builder_items', array( $this, 'add_business_aarambha_header_builder_item' ) );
            add_action( 'customize_register', array( $this, 'customize_register' ), 3 );
            add_filter( 'business_aarambha_get_template_part', array( $this, 'get_template_part' ), 10, 2 );
        }

        /**
         * Add Item on Header Builder.
         *
         * @param $business_aarambha_header_builder_item
         * @return array
         * @since    1.0.0
         */
        public function add_business_aarambha_header_builder_item( $business_aarambha_header_builder_item ) {
            $business_aarambha_header_builder_item[ $this->element ] = array(
                'icon'    => 'dashicons dashicons-cart',
                'name'    => esc_html__( 'Cart', 'business-aarambha' ),
                'id'      => $this->element,
                'section' => $this->element,
            );

            return $business_aarambha_header_builder_item;
        }

        /**
         * Callback functions for customize_register
         *
         * @since    1.0.2
         * @access   public
         *
         * @param WP_Customize_Manager $wp_customize
         * @return void
         */
        public function customize_register( $wp_customize ) {

            $wp_customize->add_section(
                Business_Aarambha_WooCommerce_Cart_Header()->element,
                array(
                    'title'    => esc_html__( 'WooCommerce Cart', 'business-aarambha' ),
                    'priority' => 80,
                    'panel'    => Business_Aarambha_Customizer_Header_Builder()->panel,
                )
            );
            require BUSINESS_AARAMBHA_DIR  . 'inc/customizer/builder/header/options/woocommerce/cart/Business_Aarambha_Customize_Header_WooCommerce_Cart_Fields.php';
        }

        /**
         * Load template part
         *
         * @param $template
         * @param $id
         * @return void
         * @since    1.0.0
         */
        function get_template_part( $template, $id ) {
            if ( ! $template && file_exists( BUSINESS_AARAMBHA_DIR . "/template-parts/header/woocommerce/{$id}.php" ) ) {
                $template = BUSINESS_AARAMBHA_DIR . "/template-parts/header/woocommerce/{$id}.php";
            }
            return $template;
        }
    }
endif;

/**
 * Create Instance for Business_Aarambha_WooCommerce_Cart_Header
 *
 * @since    1.0.0
 * @access   public
 *
 * @param
 * @return object
 */
if ( ! function_exists( 'Business_Aarambha_WooCommerce_Cart_Header' ) ) {

    function Business_Aarambha_WooCommerce_Cart_Header() {
        return Business_Aarambha_WooCommerce_Cart_Header::instance();
    }
    if( Business_Aarambha_Helper::is_woocommerce() ){
        Business_Aarambha_WooCommerce_Cart_Header()->run();
    }
}
