<?php
/**
 * Business Aarambha Theme Customizer Header WooCommerce Cart settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_WooCommerce_Cart_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {

        $this->args = [
            // Grouping Settings
            'business_aarambha_header_woocommerce_cart_group_settings' => [
                'type'              => 'group',
                'section'           => Business_Aarambha_WooCommerce_Cart_Header()->element,
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_woocommerce_cart_icon',
                            'business_aarambha_header_woocommerce_cart_icon_size'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_woocommerce_cart_icon_color',
                            'business_aarambha_header_woocommerce_cart_icon_background',
                            'business_aarambha_header_woocommerce_cart_padding',
                            'business_aarambha_header_woocommerce_cart_margin'

                        )
                    )
                ]
            ],
            // Slide in Box Icon
            'business_aarambha_header_woocommerce_cart_icon' => [
                'type'              => 'buttonset',
                'default'           => [
                    'desktop'           => 'fa-shopping-cart',
                ],
                'button_type'       => 'icon',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
                'label'             => esc_html__( 'Icon', 'business-aarambha' ),
                'description'       => esc_html__( 'Choose WooCommerce cart icon.', 'business-aarambha' ),
                'section'           => Business_Aarambha_WooCommerce_Cart_Header()->element,
                'priority'          => 10,
                'choices'           => [
                    'fa-shopping-cart'      => 'fa-shopping-cart',
                    'fa-shopping-basket'    => 'fa-shopping-basket',
                    'fa-shopping-bag'       => 'fa-shopping-bag',
                    'fa-cart-arrow-down'    => 'fa-cart-arrow-down',
                    'fa-cart-plus'          => 'fa-cart-plus',
                    'fa-truck'              => 'fa-truck'
                ]
            ],
            // Icon Size
            'business_aarambha_header_woocommerce_cart_icon_size' => [
                'type'              => 'range',
                'default'           => ['desktop' => '16px'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_range' ],
                'label'             => esc_html__( 'Icon Size', 'business-aarambha' ),
                'description'       => esc_html__( 'Set WooCommerce cart icon size.', 'business-aarambha' ),
                'section'           => Business_Aarambha_WooCommerce_Cart_Header()->element,
                'priority'          => 10,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],

            // Icon Color
            'business_aarambha_header_woocommerce_cart_icon_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Cart Icon', 'business-aarambha' ),
                'description'       => esc_html__( 'Set WooCommerce cart icon color.', 'business-aarambha' ),
                'section'           => Business_Aarambha_WooCommerce_Cart_Header()->element,
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 55,
                'inherits'          => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-link-hover)',
                ]
            ],
            // Background
            'business_aarambha_header_woocommerce_cart_icon_background' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Cart Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set WooCommerce cart icon background.', 'business-aarambha' ),
                'section'           => Business_Aarambha_WooCommerce_Cart_Header()->element,
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 60,
                'inherits'          => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-1)',
                ]
            ],
            // Padding
            'business_aarambha_header_woocommerce_cart_padding' => [
                'type'              => 'dimensions',
                'default'           => [
                    'desktop'           => [
                        'side_1'            => '12px',
                        'side_2'            => '18px',
                        'side_3'            => '12px',
                        'side_4'            => '18px',
                        'linked'            => 'off'
                    ]
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set WooCommerce cart padding.', 'business-aarambha' ),
                'section'           => Business_Aarambha_WooCommerce_Cart_Header()->element,
                'priority'          => 75,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Margin
            'business_aarambha_header_woocommerce_cart_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
                'description'       => esc_html__( 'Set WooCommerce cart margin.', 'business-aarambha' ),
                'section'           => Business_Aarambha_WooCommerce_Cart_Header()->element,
                'priority'          => 80,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ]
        ];
    }

}
new Business_Aarambha_Customize_Header_WooCommerce_Cart_Fields();
