<?php
/**
 * Business Aarambha Theme Customizer Header Toggle Menu settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Toggle_Menu_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {

        $this->args = [
            // Grouping Settings
            'business_aarambha_header_toggle_menu_group_settings' => [
                'type'              => 'group',
                'section'           => 'toggle_menu',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_toggle_menu_note_one'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_toggle_menu_note_two',
                            'business_aarambha_header_toggle_menu_icon_color',
                            'business_aarambha_header_toggle_menu_icon_background_color',
                            'business_aarambha_header_toggle_menu_note_three',
                            'business_aarambha_header_toggle_menu_text_typo',
                            'business_aarambha_header_toggle_menu_dropdown_container_menu_background',
                            'business_aarambha_header_toggle_menu_padding',
                            'business_aarambha_header_toggle_menu_margin'

                        )
                    )
                ]
            ],
            // Note One
            'business_aarambha_header_toggle_menu_note_one' => [
                'type'              => 'heading',
				'description'       => sprintf(__( 'To set menu, go to <a data-type="section" data-id="menu_locations" class="customizer-focus"><strong>Mobile Menu</strong></a>', 'business-aarambha' )),
                'section'           => 'toggle_menu',
                'priority'          => 10,
            ],
            // Note two
            'business_aarambha_header_toggle_menu_note_two' => [
                'type'              => 'heading',
                'description'       => esc_html__( 'Menu Icon', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'priority'          => 40,
            ],
            // Icon Color
            'business_aarambha_header_toggle_menu_icon_color' => [
                'type'              => 'color',
                'default'           => [
                    'color_1'           => '#23383B'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Color', 'business-aarambha' ),
                'description'       => esc_html__( 'Set trigger menu icon color.', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'priority'          => 40,
            ],
            // Icon Background Color
            'business_aarambha_header_toggle_menu_icon_background_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background Color', 'business-aarambha' ),
                'description'       => esc_html__( 'Set trigger menu icon background color.', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'priority'          => 40,
                'inherits'            => [
                    'color_1'           => 'var(--color-2)',
                ],
            ],
            // Note three
            'business_aarambha_header_toggle_menu_note_three' => [
                'type'              => 'heading',
                'description'       => esc_html__( 'Dropdown Container', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'priority'          => 60,
            ],
            // Menu Typography
            'business_aarambha_header_toggle_menu_text_typo' => [
                'type'              => 'typography',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_typography' ],
                'label'             => esc_html__( 'Menu Color', 'business-aarambha' ),
                'description'       => esc_html__( 'Set menu & submenu text color.', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'priority'          => 61,
                'units'             => [ 'px', 'rem', 'pt', 'em','vw' ],
                'inherits'            => [
                    'color_1'           => 'var(--color-2)'
                ],
                'fields'            => ['colors'=>true],
            ],
            // Menu Background
            'business_aarambha_header_toggle_menu_dropdown_container_menu_background' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Menu Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set dropdown container each menu background colors.', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'priority'          => 65,
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'inherits'            => [
                    'color_1'           => 'rgba(0, 0, 0, 0.8)',
                    'color_2'           => 'var(--color-bg-3)'
                ],
            ],
            // Container Padding
            'business_aarambha_header_toggle_menu_padding' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set toggle menu container padding.', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'priority'          => 70,
            ],
            // Container Margin
            'business_aarambha_header_toggle_menu_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
                'description'       => esc_html__( 'Set toggle menu container margin.', 'business-aarambha' ),
                'section'           => 'toggle_menu',
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'priority'          => 75,
            ],

        ];
    }

}
new Business_Aarambha_Customize_Header_Toggle_Menu_Fields();
