<?php
/**
 * Business Aarambha Theme Customizer Header Social Icons settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Social_Icons_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_social_icon_group_settings' => [
                'type'              => 'group',
                'section'           => 'social_icons',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_social_icon_note_one',
                            'business_aarambha_header_social_icon_gap',
                            'business_aarambha_header_social_icon_link_open'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_social_icon_padding',
                            'business_aarambha_header_social_icon_margin',
                            'business_aarambha_header_social_icon_note_two',
                            'business_aarambha_header_social_icon_item_icon_color',
                            'business_aarambha_header_social_icon_item_background',
                            'business_aarambha_header_social_icon_item_padding'
                        )
                    )
                ]
            ],
            // Heading One
            'business_aarambha_header_social_icon_note_one' => [
                'type'              => 'heading',
				'description'       => sprintf(__( 'Configure social icons in Global &raquo; Social &raquo; <a data-type="control" data-id="business_aarambha_social_icons" class="customizer-focus"><strong> Social Icons </strong></a>.', 'business-aarambha' )),
                'section'           => 'social_icons',
                'priority'          => 15,
            ],
            // Item Gap
            'business_aarambha_header_social_icon_gap' => [
                'type'              => 'range',
                'default'           => [
                    'desktop'           => '2px'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_range' ],
                'label'             => esc_html__( 'Item Gap', 'business-aarambha' ),
                'description'       => esc_html__( 'Set gap between each social icon lists.', 'business-aarambha' ),
                'section'           => 'social_icons',
                'priority'          => 35,
                'input_attrs'       => [
                    'min'               => 0,
                    'max'               => 50
                ],
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Link Open
            'business_aarambha_header_social_icon_link_open' => [
                'type'              => 'toggle',
                'default'           => '',
                'section'           => 'social_icons',
                'priority'          => 40,
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Link Open', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable to open the link in the new tab.', 'business-aarambha' ),
            ],
            // Padding
            'business_aarambha_header_social_icon_padding' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set social container padding.', 'business-aarambha' ),
                'section'           => 'social_icons',
                'priority'          => 42,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Margin
            'business_aarambha_header_social_icon_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
                'description'       => esc_html__( 'Set social container margin.', 'business-aarambha' ),
                'section'           => 'social_icons',
                'priority'          => 45,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Heading One
            'business_aarambha_header_social_icon_note_two' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'ITEM', 'business-aarambha' ),
                'section'           => 'social_icons',
                'priority'          => 50,
            ],
            // Icon Color
            'business_aarambha_header_social_icon_item_icon_color' => [
                'type'              => 'color',
                'default'           => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-2)'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Icon', 'business-aarambha' ),
                'description'       => esc_html__( 'Set each items icon as same color.', 'business-aarambha' ),
                'section'           => 'social_icons',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'inherits'          => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-2)'
                ],
                'priority'          => 55,
            ],
            // Background Color
            'business_aarambha_header_social_icon_item_background' => [
                'type'              => 'color',
                'default'           => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-3)'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set each item background color.', 'business-aarambha' ),
                'section'           => 'social_icons',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'inherits'          => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-3)'
                ],
                'priority'          => 60,
            ],
            // Padding
            'business_aarambha_header_social_icon_item_padding' => [
                'type'              => 'dimensions',
                'default'           => [
                    'desktop'           => [
                        'side_1'            => '11px',
                        'side_2'            => '18px',
                        'side_3'            => '11px',
                        'side_4'            => '18px',
                        'linked'            => 'off'
                    ]
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set each item padding.', 'business-aarambha' ),
                'section'           => 'social_icons',
                'priority'          => 80,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ]
        ];
    }

}
new Business_Aarambha_Customize_Header_Social_Icons_Fields();
