<?php
/**
 * Business Aarambha Theme Customizer Header Site Identify settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Site_Identity_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_site_identity_group_settings' => [
                'type'              => 'group',
                'section'           => 'title_tagline',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'custom_logo',
                            'business_aarambha_header_site_title_enable',
                            'blogname',
                            'business_aarambha_header_site_tagline_enable',
                            'blogdescription',
                            'site_icon'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_site_identify_note_two',
                            'business_aarambha_header_site_title_typo',
                            'business_aarambha_header_site_tagline_typo',
                            'business_aarambha_header_site_identify_note_three',
                            'business_aarambha_header_site_identify_padding',
                            'business_aarambha_header_site_identify_margin'
                        )
                    )
                ]
            ],
            // Site title
            'business_aarambha_header_site_title_enable' => [
                'type'              => 'toggle',
                'default'           => ['desktop'=> 'true'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Site Title', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 30
            ],
            // Site tagline
            'business_aarambha_header_site_tagline_enable' => [
                'type'              => 'toggle',
                'default'           => ['desktop'=> 'true'],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Tagline', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 40
            ],
            // Note Two
            'business_aarambha_header_site_identify_note_two' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'SITE TITLE & TAGLINE', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 65,
            ],
            // Site Title
            'business_aarambha_header_site_title_typo' => [
                'type'              => 'typography',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_typography' ],
                'label'             => esc_html__( 'Site Title', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 70,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'units'             => [ 'px', 'rem', 'pt', 'em','vw' ],
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'inherits'          => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-link-hover)'
                ],
				'fields'            => ['font_family'=>true,'font_variant'=>true,'font_size'=>true,'letter_spacing'=>true,'colors'=>true]
            ],
            // Site Tagline
            'business_aarambha_header_site_tagline_typo' => [
                'type'              => 'typography',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_typography' ],
                'label'             => esc_html__( 'Tagline', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 75,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'units'             => [ 'px', 'rem', 'pt', 'em','vw' ],
                'inherits'          => [
                    'color_1'           => 'var(--color-link)'
                ],
				'fields'            => ['font_size'=>true,'colors'=>true]
            ],
            // Note Three
            'business_aarambha_header_site_identify_note_three' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'SITE IDENTIFY CONTAINER', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 80,
            ],
            // Padding
            'business_aarambha_header_site_identify_padding' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
				'description'       => esc_html__( 'Set container padding.', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 85,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Margin
            'business_aarambha_header_site_identify_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
				'description'       => esc_html__( 'Set container margin.', 'business-aarambha' ),
                'section'           => 'title_tagline',
                'priority'          => 90,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ]
        ];
    }

}
new Business_Aarambha_Customize_Header_Site_Identity_Fields();
