<?php
/**
 * Business Aarambha Theme Customizer Header Search Icon settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Search_Icon_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_search_icon_group_settings' => [
                'type'              => 'group',
                'section'           => 'search_icon',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_search_icon_placeholder'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_search_icon_color',
                            'business_aarambha_header_search_icon_background',
                            'business_aarambha_header_search_icon_container_padding',
                            'business_aarambha_header_search_icon_container_margin'
                        )
                    )
                ]
            ],
            // Placeholder
            'business_aarambha_header_search_icon_placeholder' => [
                'type'              => 'text',
                'default'           => esc_html__( 'Search...', 'business-aarambha' ),
                'sanitize_callback' => 'sanitize_text_field',
                'label'             => esc_html__( 'Placeholder', 'business-aarambha' ),
                'description'       => esc_html__( 'Set Search Model with placeholder.', 'business-aarambha' ),
                'section'           => 'search_icon',
                'priority'          => 15,
            ],
            // Icon Color
            'business_aarambha_header_search_icon_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Icon', 'business-aarambha' ),
                'description'       => esc_html__( 'Set icon color.', 'business-aarambha' ),
                'section'           => 'search_icon',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 20,
                'inherits'          => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-link-hover)',
                ]
            ],
            // Background
            'business_aarambha_header_search_icon_background' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set icon  background.', 'business-aarambha' ),
                'section'           => 'search_icon',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 25,
                'inherits'          => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-1)',
                ]
            ],
            // Padding
            'business_aarambha_header_search_icon_container_padding' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set search icon container padding.', 'business-aarambha' ),
                'section'           => 'search_icon',
                'priority'          => 31,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Margin
            'business_aarambha_header_search_icon_container_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
                'description'       => esc_html__( 'Set search icon container margin.', 'business-aarambha' ),
                'section'           => 'search_icon',
                'priority'          => 32,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ]
        ];
    }

}
new Business_Aarambha_Customize_Header_Search_Icon_Fields();
