<?php
/**
 * Business Aarambha Theme Customizer Header Primary Menu settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Primary_Menu_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_primary_menu_group_settings' => [
                'type'              => 'group',
                'section'           => 'primary_menu',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_primary_menu_note_one',
                            'business_aarambha_header_primary_parent_menu_spacing'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_primary_menu_note_five',
                            'business_aarambha_header_primary_parent_menu_colors',
                            'business_aarambha_header_primary_parent_menu_background_color',
                            'business_aarambha_header_primary_menu_note_three',
                            'business_aarambha_header_primary_child_menu_colors',
                            'business_aarambha_header_primary_child_menu_background_colors',
                            'business_aarambha_header_primary_child_menu_border',
                            'business_aarambha_header_primary_menu_note_four',
							'business_aarambha_header_primary_menu_container_padding',
							'business_aarambha_header_primary_menu_container_margin',

                        )
                    )
                ]
            ],
            // Note One
            'business_aarambha_header_primary_menu_note_one' => [
                'type'              => 'heading',
				'description'       => sprintf(__( 'To set menu, go to <a data-type="section" data-id="menu_locations" class="customizer-focus"><strong>Primary Menu</strong></a>', 'business-aarambha' )),
                'section'           => 'primary_menu',
                'priority'          => 10,
            ],
            // Items Spacing
            'business_aarambha_header_primary_parent_menu_spacing' => [
                'type'              => 'range',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_range' ],
                'label'             => esc_html__( 'Menu Spacing', 'business-aarambha' ),
                'description'       => esc_html__( 'Slide to change the value of Parent Menu Spacing.', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
                'priority'          => 20
            ],
            // Heading Three
            'business_aarambha_header_primary_menu_note_five' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'PARENT MENU', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'priority'          => 53,
            ],
            // Menu Colors
            'business_aarambha_header_primary_parent_menu_colors' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Colors', 'business-aarambha' ),
                'description'       => esc_html__( 'Set parent menu each item normal and hover colors.', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'inherits'            => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-link-hover)',
                ],
                'priority'          => 55,
            ],
            // Menu Background
            'business_aarambha_header_primary_parent_menu_background_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set parent menu each item background.', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'priority'          => 60,
                'inherits'            => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-1)',
                ],
            ],
            // Heading Three
            'business_aarambha_header_primary_menu_note_three' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'CHILD MENU', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'priority'          => 70,
            ],
            // Child Menu Colors
            'business_aarambha_header_primary_child_menu_colors' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Colors', 'business-aarambha' ),
                'description'       => esc_html__( 'Set child menu each item normal and hover colors.', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'inherits'            => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-bg-1)',
                ],
                'priority'          => 75,
            ],
            // SubMenu Background
            'business_aarambha_header_primary_child_menu_background_colors' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background Colors', 'business-aarambha' ),
                'description'       => esc_html__( 'Set child menu each item background colors.', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' )
                ],
                'priority'          => 80,
                'inherits'            => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-3)',
                ],
            ],
            // child menu border
            'business_aarambha_header_primary_child_menu_border' => [
                'type'              => 'border',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_border' ],
                'label'             => esc_html__( 'Border Color', 'business-aarambha' ),
                'description'       => esc_html__( 'Set child menu bottom border color.', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'priority'          => 90,
                'fields'            => ['colors'=>true],
                'inherits'            => [
                    'color_1'           => 'var(--color-1)'
                ],
            ],
            // Heading four
            'business_aarambha_header_primary_menu_note_four' => [
                'type'              => 'heading',
                'label'             => esc_html__( 'CONTAINER', 'business-aarambha' ),
                'section'           => 'primary_menu',
                'priority'          => 105,
            ],
			// Container Padding
			'business_aarambha_header_primary_menu_container_padding' => [
				'type'              => 'dimensions',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
				'label'             => esc_html__( 'Padding', 'business-aarambha' ),
				'description'       => esc_html__( 'Set primary menu container padding.', 'business-aarambha' ),
				'section'           => 'primary_menu',
				'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
				'priority'          => 110,
			],
			// Container Margin
			'business_aarambha_header_primary_menu_container_margin' => [
				'type'              => 'dimensions',
				'default'           => '',
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
				'label'             => esc_html__( 'Margin', 'business-aarambha' ),
				'description'       => esc_html__( 'Set primary menu container margin.', 'business-aarambha' ),
				'section'           => 'primary_menu',
				'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
				'priority'          => 115,
			]
        ];
    }

}
new Business_Aarambha_Customize_Header_Primary_Menu_Fields();
