<?php
/**
 * Business Aarambha Theme Customizer Header Main Row settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Main_Row_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_main_group_settings' => [
                'type'              => 'group',
                'section'           => 'business_aarambha_header_main',
                'priority'          => 5,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_main_row_height',
                            'business_aarambha_header_main_row_left_col_content_justify',
                            'business_aarambha_header_main_row_center_col_content_justify',
                            'business_aarambha_header_main_row_right_col_content_justify'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_main_row_background_overlay'
                        )
                    )
                ]
            ],
			// Min Height
			'business_aarambha_header_main_row_height' => [
				'type'              => 'range',
				'default'           => ['desktop' => '80px'],
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_range' ],
				'label'             => esc_html__( 'Min Height', 'business-aarambha' ),
				'description'       => esc_html__( 'To set Min Height at the main row of Header.', 'business-aarambha' ),
				'section'           => 'business_aarambha_header_main',
				'priority'          => 10,
				'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
				'input_attrs'       => [
					'min'               => 15,
					'max'               => 400
				]
			],
			// Left Column Justify Content
			'business_aarambha_header_main_row_left_col_content_justify' => [
				'type'              => 'buttonset',
				'default'           => [
					'desktop'   => 'start',
					'tablet'    => 'start',
					'mobile'    => 'start'
				],
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
				'label'             => esc_html__( 'Left Column', 'business-aarambha' ),
				'description'       => esc_html__( 'Choose position for the content in the Left Column.', 'business-aarambha' ),
				'section'           => 'business_aarambha_header_main',
				'priority'          => 15,
				'choices'           => [
					'start'     => esc_html__( 'Start', 'business-aarambha' ),
					'center'    => esc_html__( 'Center', 'business-aarambha' ),
					'end'       => esc_html__( 'End', 'business-aarambha' )
				],
				'responsive'        => ['desktop','tablet','mobile'],
			],
			// Center Column Justify Content
			'business_aarambha_header_main_row_center_col_content_justify' => [
				'type'              => 'buttonset',
				'default'           => [
					'desktop'   => 'center',
					'tablet'    => 'center',
					'mobile'    => 'center'
				],
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
				'label'             => esc_html__( 'Center Column', 'business-aarambha' ),
				'description'       => esc_html__( ' Choose position for the content in the Center Column.', 'business-aarambha' ),
				'section'           => 'business_aarambha_header_main',
				'priority'          => 20,
				'choices'           => [
					'start'     => esc_html__( 'Start', 'business-aarambha' ),
					'center'    => esc_html__( 'Center', 'business-aarambha' ),
					'end'       => esc_html__( 'End', 'business-aarambha' )
				],
				'responsive'        => ['desktop','tablet','mobile'],
			],
			// Right Column Justify Content
			'business_aarambha_header_main_row_right_col_content_justify' => [
				'type'              => 'buttonset',
				'default'           => [
					'desktop'   => 'end',
					'tablet'    => 'end',
					'mobile'    => 'end'
				],
				'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_buttonset' ],
				'label'             => esc_html__( 'Right Column', 'business-aarambha' ),
				'description'       => esc_html__( 'Choose position for the content in the Right Column.', 'business-aarambha' ),
				'section'           => 'business_aarambha_header_main',
				'priority'          => 25,
				'choices'           => [
					'start'     => esc_html__( 'Start', 'business-aarambha' ),
					'center'    => esc_html__( 'Center', 'business-aarambha' ),
					'end'       => esc_html__( 'End', 'business-aarambha' )
				],
				'responsive'        => ['desktop','tablet','mobile'],
			],
            // Background Overlay
            'business_aarambha_header_main_row_background_overlay' => [
                'type'              => 'background',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_background' ],
                'label'             => esc_html__( 'Background Overlay', 'business-aarambha' ),
                'description'       => esc_html__( 'Set Background overlay color for main row container.', 'business-aarambha' ),
                'section'           => 'business_aarambha_header_main',
                'priority'          => 35,
                'inherits'          => [
                    'color_1'           => 'var(--color-bg-1)'
                ],
                'fields'            => ['colors' => true],
            ],
        ];
    }

}
new Business_Aarambha_Customize_Header_Main_Row_Fields();
