<?php
/**
 * Business Aarambha Theme Customizer Header HTML settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Html_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_html_group_settings' => [
                'type'              => 'group',
                'section'           => 'html',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'custom_logo',
                            'business_aarambha_header_html_text'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_html_text_link_color',
                            'business_aarambha_header_html_text_typo',
                            'business_aarambha_header_html_padding',
                            'business_aarambha_header_html_margin'
                        )
                    )
                ]
            ],
            // Textarea
            'business_aarambha_header_html_text' => [
                'type'              => 'editor',
                'default'           => '',
                'sanitize_callback' => 'wp_kses_post',
                'label'             => esc_html__( 'HTML', 'business-aarambha' ),
                'description'       => esc_html__( 'Enter Text/Simple HTML Code', 'business-aarambha' ),
                'section'           => 'html',
                'priority'          => 15,
            ],
            // Text Typo
            'business_aarambha_header_html_text_typo' => [
                'type'              => 'typography',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_typography' ],
                'label'             => esc_html__( 'Text Color', 'business-aarambha' ),
                'section'           => 'html',
                'priority'          => 20,
                'inherits'          => [
                    'color_1'           => 'var(--color-1)'
                ],
                'fields'            => ['colors'=>true]
            ],
            // link color
            'business_aarambha_header_html_text_link_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Link Color', 'business-aarambha' ),
                'section'           => 'html',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 25,
                'inherits'          => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-link-hover)',
                ]
            ],
            // Padding
            'business_aarambha_header_html_padding' => [
                'type'              => 'dimensions',
                'default'           => [
                    'desktop'           => [
                        'side_1'            => '10px',
                        'side_3'            => '10px',
                        'linked'            => 'off'
                    ]
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set HTML container padding.', 'business-aarambha' ),
                'section'           => 'html',
                'priority'          => 55,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Margin
            'business_aarambha_header_html_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
                'description'       => esc_html__( 'Set HTML container margin.', 'business-aarambha' ),
                'section'           => 'html',
                'priority'          => 60,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ]
        ];
    }

}
new Business_Aarambha_Customize_Header_Html_Fields();
