<?php
/**
 * Business Aarambha Theme Customizer Header Button settings
 *
 * @package Business_Aarambha
 */

class Business_Aarambha_Customize_Header_Button_Fields extends Business_Aarambha_Customize_Base_Field {

    /**
     * Arguments for fields.
     *
     * @return void
     */
    public function init() {
        $this->args = [
            // Grouping Settings
            'business_aarambha_header_button_group_settings' => [
                'type'              => 'group',
                'section'           => 'button_one',
                'priority'          => 10,
                'choices'           => [
                    'normal'            => array(
                        'tab-title'     => esc_html__( 'General', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_button_text',
                            'business_aarambha_header_button_url',
                            'business_aarambha_header_button_url_target'
                        )
                    ),
                    'hover'         => array(
                        'tab-title'     => esc_html__( 'Style', 'business-aarambha' ),
                        'controls'      => array(
                            'business_aarambha_header_button_color',
                            'business_aarambha_header_button_background',
                            'business_aarambha_header_button_padding',
                            'business_aarambha_header_button_margin'
                        )
                    )
                ]
            ],
            // Text
            'business_aarambha_header_button_text' => [
                'type'              => 'text',
                'default'           => esc_html__( 'ENG', 'business-aarambha' ),
                'sanitize_callback' => 'sanitize_text_field',
                'label'             => esc_html__( 'Text', 'business-aarambha' ),
                'section'           => 'button_one',
                'priority'          => 20,
            ],
            // URL
            'business_aarambha_header_button_url' => [
                'type'              => 'url',
                'default'           => '#',
                'sanitize_callback' => 'esc_url_raw',
                'label'             => esc_html__( 'URL', 'business-aarambha' ),
                'section'           => 'button_one',
                'priority'          => 25,
            ],
            // Link Open
            'business_aarambha_header_button_url_target' => [
                'type'              => 'toggle',
                'default'           => '',
                'section'           => 'button_one',
                'priority'          => 50,
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_toggle' ],
                'label'             => esc_html__( 'Link Open', 'business-aarambha' ),
                'description'       => esc_html__( 'Enable to open the link in the new tab.', 'business-aarambha' ),
            ],
            // Button Color
            'business_aarambha_header_button_color' => [
                'type'              => 'color',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Button', 'business-aarambha' ),
                'description'       => esc_html__( 'Set button color.', 'business-aarambha' ),
                'section'           => 'button_one',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 55,
                'inherits'          => [
                    'color_1'           => 'var(--color-link)',
                    'color_2'           => 'var(--color-2)',
                ]
            ],
            // Background
            'business_aarambha_header_button_background' => [
                'type'              => 'color',
                'default'           => [
                    'color_2'           => 'var(--color-bg-3)'
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_color' ],
                'label'             => esc_html__( 'Background', 'business-aarambha' ),
                'description'       => esc_html__( 'Set button background.', 'business-aarambha' ),
                'section'           => 'button_one',
                'colors'            => [
                    'color_1'           => esc_html__( 'Normal', 'business-aarambha' ),
                    'color_2'           => esc_html__( 'Hover', 'business-aarambha' ),
                ],
                'priority'          => 60,
                'inherits'          => [
                    'color_1'           => 'var(--color-bg-1)',
                    'color_2'           => 'var(--color-bg-3)',
                ]
            ],
			
            // Padding
            'business_aarambha_header_button_padding' => [
                'type'              => 'dimensions',
                'default'           => [
                    'desktop'           => [
                        'side_1'            => '12px',
                        'side_2'            => '18px',
                        'side_3'            => '12px',
                        'side_4'            => '18px',
                        'linked'            => 'off'
                    ]
                ],
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Padding', 'business-aarambha' ),
                'description'       => esc_html__( 'Set button padding.', 'business-aarambha' ),
                'section'           => 'button_one',
                'priority'          => 75,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
            // Margin
            'business_aarambha_header_button_margin' => [
                'type'              => 'dimensions',
                'default'           => '',
                'sanitize_callback' => ['Business_Aarambha_Customizer_Sanitize_Callback', 'sanitize_dimensions' ],
                'label'             => esc_html__( 'Margin', 'business-aarambha' ),
                'description'       => esc_html__( 'Set button margin.', 'business-aarambha' ),
                'section'           => 'button_one',
                'priority'          => 80,
                'responsive'        => [ 'desktop', 'tablet', 'mobile' ],
            ],
        ];
    }

}
new Business_Aarambha_Customize_Header_Button_Fields();
